/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.common.inventory.ContainerChiselHitech;
import team.chisel.common.util.SoundUtil;

public class PacketChiselButton
implements IMessage {
    private int[] slotIds;

    public PacketChiselButton(int ... slots) {
        this.slotIds = slots;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.slotIds.length);
        for (int i : this.slotIds) {
            buf.writeByte(i);
        }
    }

    public void fromBytes(ByteBuf buf) {
        byte len = buf.readByte();
        this.slotIds = new int[len];
        for (int i = 0; i < this.slotIds.length; ++i) {
            this.slotIds[i] = buf.readByte();
        }
    }

    public static void chiselAll(EntityPlayer player, int[] slots) {
        if (player.field_71070_bA instanceof ContainerChiselHitech) {
            ContainerChiselHitech container = (ContainerChiselHitech)player.field_71070_bA;
            ItemStack chisel = container.getChisel();
            ItemStack target = container.getTargetStack();
            ICarvingRegistry carving = CarvingUtils.getChiselRegistry();
            if (chisel.func_190926_b() || target.func_190926_b()) {
                return;
            }
            boolean playSound = false;
            for (int i : slots) {
                ItemStack s = player.field_71071_by.func_70301_a(i);
                if (!s.func_190926_b()) {
                    if (carving.getGroup(target) != carving.getGroup(s)) {
                        return;
                    }
                    ItemStack stack = target.func_77946_l();
                    int toCraft = Math.min(s.func_190916_E(), stack.func_77976_d());
                    if (chisel.func_77984_f()) {
                        int damageLeft = chisel.func_77958_k() - chisel.func_77952_i() + 1;
                        toCraft = Math.min(toCraft, damageLeft);
                        stack.func_190920_e(toCraft);
                        chisel.func_77972_a(toCraft, (EntityLivingBase)player);
                    }
                    if (chisel.func_190926_b()) {
                        player.field_71071_by.func_70299_a(i, stack);
                        container.getInventoryChisel().getStackInSpecialSlot().func_190918_g(toCraft);
                        player.field_71071_by.func_70299_a(container.getChiselSlot(), ItemStack.field_190927_a);
                        if (s.func_190916_E() > toCraft) {
                            ItemStack remainder = s.func_77946_l();
                            remainder.func_190918_g(toCraft);
                            if (!player.field_71071_by.func_70441_a(remainder)) {
                                player.func_71019_a(remainder, false);
                            }
                        }
                    } else if (toCraft < s.func_190916_E()) {
                        s.func_190918_g(toCraft);
                        if (!player.field_71071_by.func_70441_a(stack)) {
                            player.func_71019_a(stack, false);
                        }
                    } else {
                        player.field_71071_by.func_70299_a(i, stack);
                    }
                    playSound = true;
                }
                if (chisel.func_190916_E() >= 1) continue;
                return;
            }
            if (playSound) {
                SoundUtil.playSound(player, chisel, carving.getVariation(target).getBlockState());
            }
        }
    }

    public PacketChiselButton() {
    }

    public static class Handler
    implements IMessageHandler<PacketChiselButton, IMessage> {
        public IMessage onMessage(PacketChiselButton message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> PacketChiselButton.chiselAll((EntityPlayer)player, message.slotIds));
            return null;
        }
    }
}

