/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.net;

import com.feed_the_beast.ftblib.FTBLibNotifications;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import java.util.Collection;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.ChunkPos;

public class MessageClaimedChunksModify
extends MessageToServer {
    public static final int CLAIM = 0;
    public static final int UNCLAIM = 1;
    public static final int LOAD = 2;
    public static final int UNLOAD = 3;
    private int startX;
    private int startZ;
    private int action;
    private Collection<ChunkPos> chunks;

    public MessageClaimedChunksModify() {
    }

    public MessageClaimedChunksModify(int sx, int sz, int a, Collection<ChunkPos> c) {
        this.startX = sx;
        this.startZ = sz;
        this.action = a;
        this.chunks = c;
    }

    public NetworkWrapper getWrapper() {
        return FTBUtilitiesNetHandler.CLAIMS;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.startX);
        data.writeInt(this.startZ);
        data.writeByte(this.action);
        data.writeCollection(this.chunks, DataOut.CHUNK_POS);
    }

    public void readData(DataIn data) {
        this.startX = data.readInt();
        this.startZ = data.readInt();
        this.action = data.readUnsignedByte();
        this.chunks = data.readCollection(null, DataIn.CHUNK_POS);
    }

    public void onMessage(EntityPlayerMP player) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ForgePlayer p = ClaimedChunks.instance.universe.getPlayer((ICommandSender)player);
        if (!p.hasTeam()) {
            FTBLibNotifications.NO_TEAM.send(player.field_71133_b, (EntityPlayer)player);
            return;
        }
        for (ChunkPos pos0 : this.chunks) {
            ChunkDimPos pos = new ChunkDimPos(pos0, player.field_71093_bK);
            switch (this.action) {
                case 0: {
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "ftbutilities.other_player.claims.claim")) break;
                    ClaimedChunks.instance.claimChunk(p, pos, true);
                    break;
                }
                case 1: {
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "ftbutilities.other_player.claims.unclaim")) break;
                    ClaimedChunks.instance.unclaimChunk(pos);
                    break;
                }
                case 2: {
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "ftbutilities.other_player.claims.load")) break;
                    ClaimedChunks.instance.loadChunk(p.team, pos);
                    break;
                }
                case 3: {
                    if (!ClaimedChunks.instance.canPlayerModify(p, pos, "ftbutilities.other_player.claims.unload")) break;
                    ClaimedChunks.instance.unloadChunk(pos);
                }
            }
        }
    }
}

