/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration;

import com.feed_the_beast.ftblib.events.RegisterAdminPanelActionsEvent;
import com.feed_the_beast.ftblib.events.RegisterSyncDataEvent;
import com.feed_the_beast.ftblib.events.ServerReloadEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerDataEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamConfigEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.RegisterTeamGuiActionsEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseClearCacheEvent;
import com.feed_the_beast.ftblib.lib.EventHandler;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.data.AdminPanelAction;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ISyncData;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.Badges;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesTeamData;
import com.feed_the_beast.ftbutilities.handlers.FTBUtilitiesSyncData;
import com.feed_the_beast.ftbutilities.net.MessageViewCrashList;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.io.File;
import java.util.OptionalInt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@EventHandler
public class FTBLibIntegration {
    public static final ResourceLocation RELOAD_CONFIG = new ResourceLocation("ftbutilities", "config");
    public static final ResourceLocation RELOAD_RANKS = new ResourceLocation("ftbutilities", "ranks");
    public static final ResourceLocation RELOAD_BADGES = new ResourceLocation("ftbutilities", "badges");
    public static final ResourceLocation LOGIN_STARTING_ITEMS = new ResourceLocation("ftbutilities", "starting_items");

    @SubscribeEvent
    public static void registerReloadIds(ServerReloadEvent.RegisterIds event) {
        event.register(RELOAD_CONFIG);
        event.register(RELOAD_RANKS);
        event.register(RELOAD_BADGES);
    }

    @SubscribeEvent
    public static void onServerReload(ServerReloadEvent event) {
        if (event.reload(RELOAD_CONFIG)) {
            FTBUtilitiesConfig.sync();
        }
        if (event.reload(RELOAD_RANKS) && !Ranks.INSTANCE.reload()) {
            event.failedToReload(RELOAD_RANKS);
        }
        if (event.reload(RELOAD_BADGES) && !Badges.reloadServerBadges(event.getUniverse())) {
            event.failedToReload(RELOAD_BADGES);
        }
    }

    @SubscribeEvent
    public static void onCacheCleared(UniverseClearCacheEvent event) {
        if (Ranks.INSTANCE != null) {
            Ranks.INSTANCE.clearCache();
        }
    }

    @SubscribeEvent
    public static void registerPlayerData(ForgePlayerDataEvent event) {
        event.register("ftbutilities", (INBTSerializable)new FTBUtilitiesPlayerData(event.getPlayer()));
    }

    @SubscribeEvent
    public static void registerTeamData(ForgeTeamDataEvent event) {
        event.register("ftbutilities", (INBTSerializable)new FTBUtilitiesTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public static void registerSyncData(RegisterSyncDataEvent event) {
        event.register("ftbutilities", (ISyncData)new FTBUtilitiesSyncData());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        if (event.isFirstLogin(LOGIN_STARTING_ITEMS) && FTBUtilitiesConfig.login.enable_starting_items) {
            for (ItemStack stack : FTBUtilitiesConfig.login.getStartingItems()) {
                InvUtils.giveItem((EntityPlayer)player, (ItemStack)stack.func_77946_l());
            }
        }
        if (FTBUtilitiesConfig.login.enable_motd) {
            for (ITextComponent t : FTBUtilitiesConfig.login.getMOTD()) {
                player.func_145747_a(t);
            }
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(ForgePlayerLoggedOutEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
        Badges.update(event.getPlayer().getId());
    }

    @SubscribeEvent
    public static void getPlayerSettings(ForgePlayerConfigEvent event) {
        FTBUtilitiesPlayerData.get(event.getPlayer()).addConfig(event.getConfig());
    }

    @SubscribeEvent
    public static void getTeamSettings(ForgeTeamConfigEvent event) {
        FTBUtilitiesTeamData.get(event.getTeam()).addConfig(event);
    }

    @SubscribeEvent
    public static void onTeamDeleted(ForgeTeamDeletedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.unclaimAllChunks(event.getTeam(), OptionalInt.empty());
        }
    }

    @SubscribeEvent
    public static void registerTeamGuiActions(RegisterTeamGuiActionsEvent event) {
    }

    @SubscribeEvent
    public static void registerAdminPanelActions(RegisterAdminPanelActionsEvent event) {
        event.register(new AdminPanelAction("ftbutilities", "crash_reports", ItemIcon.getItemIcon((ItemStack)new ItemStack(Blocks.field_180401_cv)), 0){

            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean((boolean)player.hasPermission("admin_panel.ftbutilities.crash_reports.view"));
            }

            public void onAction(ForgePlayer player, NBTTagCompound data) {
                new MessageViewCrashList(new File(CommonUtils.folderMinecraft, "crash-reports")).sendTo(player.getPlayer());
            }
        });
        event.register(new AdminPanelAction("ftbutilities", "edit_world", GuiIcons.GLOBE, 0){

            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean((boolean)player.hasPermission("admin_panel.ftbutilities.edit_world.gamerules"));
            }

            public void onAction(ForgePlayer player, NBTTagCompound data) {
                ConfigGroup group = new ConfigGroup((ITextComponent)new TextComponentTranslation("admin_panel.ftbutilities.edit_world", new Object[0]));
                if (player.hasPermission("admin_panel.ftbutilities.edit_world.gamerules")) {
                    final GameRules gameRules = player.team.universe.world.func_82736_K();
                    block4: for (final String key : gameRules.func_82763_b()) {
                        switch (this.getType(gameRules, key)) {
                            case BOOLEAN_VALUE: {
                                group.add("gamerules", key, (ConfigValue)new ConfigBoolean(gameRules.func_82766_b(key)){

                                    public boolean getBoolean() {
                                        return gameRules.func_82766_b(key);
                                    }

                                    public void setBoolean(boolean value) {
                                        gameRules.func_82764_b(key, Boolean.toString(value));
                                    }
                                }).setDisplayName((ITextComponent)new TextComponentString(StringUtils.camelCaseToWords((String)key)));
                                continue block4;
                            }
                            case NUMERICAL_VALUE: {
                                group.add("gamerules", key, (ConfigValue)new ConfigInt(gameRules.func_180263_c(key)){

                                    public int getInt() {
                                        return gameRules.func_180263_c(key);
                                    }

                                    public void setInt(int value) {
                                        gameRules.func_82764_b(key, Integer.toString(value));
                                    }
                                }).setDisplayName((ITextComponent)new TextComponentString(StringUtils.camelCaseToWords((String)key)));
                                continue block4;
                            }
                            default: {
                                group.add("gamerules", key, (ConfigValue)new ConfigString(gameRules.func_82767_a(key)){

                                    public String getString() {
                                        return gameRules.func_82767_a(key);
                                    }

                                    public void setString(String value) {
                                        gameRules.func_82764_b(key, value);
                                    }
                                }).setDisplayName((ITextComponent)new TextComponentString(StringUtils.camelCaseToWords((String)key)));
                            }
                        }
                    }
                }
                FTBLibAPI.editServerConfig((EntityPlayerMP)player.getPlayer(), (ConfigGroup)group, (IConfigCallback)IConfigCallback.DEFAULT);
            }

            private GameRules.ValueType getType(GameRules gameRules, String key) {
                if (gameRules.func_180264_a(key, GameRules.ValueType.BOOLEAN_VALUE)) {
                    return GameRules.ValueType.BOOLEAN_VALUE;
                }
                if (gameRules.func_180264_a(key, GameRules.ValueType.NUMERICAL_VALUE)) {
                    return GameRules.ValueType.NUMERICAL_VALUE;
                }
                if (gameRules.func_180264_a(key, GameRules.ValueType.FUNCTION)) {
                    return GameRules.ValueType.FUNCTION;
                }
                return GameRules.ValueType.ANY_VALUE;
            }
        });
    }
}

