/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class Leaderboard {
    public final ResourceLocation id;
    private final ITextComponent title;
    private final Function<ForgePlayer, ITextComponent> playerToValue;
    private final Comparator<ForgePlayer> comparator;
    private final Predicate<ForgePlayer> validValue;

    public Leaderboard(ResourceLocation _id, ITextComponent t, Function<ForgePlayer, ITextComponent> v, Comparator<ForgePlayer> c, Predicate<ForgePlayer> vv) {
        this.id = _id;
        this.title = t;
        this.playerToValue = v;
        this.comparator = c.thenComparing((o1, o2) -> o1.getDisplayNameString().compareToIgnoreCase(o2.getDisplayNameString()));
        this.validValue = vv;
    }

    public final ITextComponent getTitle() {
        return this.title;
    }

    public final Comparator<ForgePlayer> getComparator() {
        return this.comparator;
    }

    public final ITextComponent createValue(ForgePlayer player) {
        return this.playerToValue.apply(player);
    }

    public final boolean hasValidValue(ForgePlayer player) {
        return this.validValue.test(player);
    }

    public static class FromStat
    extends Leaderboard {
        public static final IntFunction<ITextComponent> DEFAULT = value -> new TextComponentString(value <= 0 ? "0" : Integer.toString(value));
        public static final IntFunction<ITextComponent> TIME = value -> new TextComponentString("[" + (int)((double)value / 72000.0 + 0.5) + "h] " + StringUtils.getTimeStringTicks((long)value));

        public FromStat(ResourceLocation id, ITextComponent t, StatBase statBase, boolean from0to1, IntFunction<ITextComponent> valueToString) {
            super(id, t, (ForgePlayer player) -> (ITextComponent)valueToString.apply(player.stats().func_77444_a(statBase)), (o1, o2) -> {
                int i = Integer.compare(o1.stats().func_77444_a(statBase), o2.stats().func_77444_a(statBase));
                return from0to1 ? i : -i;
            }, (ForgePlayer player) -> player.stats().func_77444_a(statBase) > 0);
        }

        public FromStat(ResourceLocation id, StatBase statBase, boolean from0to1, IntFunction<ITextComponent> valueToString) {
            this(id, StringUtils.color((ITextComponent)statBase.func_150951_e(), null), statBase, from0to1, valueToString);
        }
    }
}

