/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockPosContainer;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.BlockInteractionType;
import com.feed_the_beast.ftbutilities.data.ClaimResult;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesLoadedChunkManager;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesTeamData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.events.chunks.ChunkModifiedEvent;
import com.feed_the_beast.ftbutilities.handlers.FTBUtilitiesPlayerEventHandler;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksUpdate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;

public class ClaimedChunks {
    public static ClaimedChunks instance;
    public final Universe universe;
    private final Collection<ClaimedChunk> pendingChunks = new HashSet<ClaimedChunk>();
    private final Map<ChunkDimPos, ClaimedChunk> map = new HashMap<ChunkDimPos, ClaimedChunk>();
    public long nextChunkloaderUpdate;
    private boolean isDirty = true;

    public static boolean isActive() {
        return instance != null && FTBUtilitiesConfig.world.chunk_claiming;
    }

    public ClaimedChunks(Universe u) {
        this.universe = u;
    }

    @Nullable
    public ForgeTeam getChunkTeam(ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        return chunk == null ? null : chunk.getTeam();
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void clear() {
        this.pendingChunks.clear();
        this.map.clear();
        this.nextChunkloaderUpdate = 0L;
        this.isDirty = true;
    }

    public void processQueue() {
        if (!this.pendingChunks.isEmpty()) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                ClaimedChunk prevChunk = this.map.put(chunk.getPos(), chunk);
                if (prevChunk != null && prevChunk != chunk) {
                    prevChunk.setInvalid();
                }
                this.markDirty();
            }
            this.pendingChunks.clear();
        }
        Iterator<ClaimedChunk> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            ClaimedChunk chunk;
            chunk = iterator.next();
            if (!chunk.isInvalid()) continue;
            FTBUtilitiesLoadedChunkManager.INSTANCE.unforceChunk(chunk);
            iterator.remove();
        }
    }

    public void update(MinecraftServer server, long nowTime) {
        if (this.nextChunkloaderUpdate <= nowTime) {
            this.nextChunkloaderUpdate = nowTime + 60000L;
            this.markDirty();
        }
        if (this.isDirty) {
            this.processQueue();
            if (FTBUtilitiesConfig.world.chunk_loading) {
                for (ForgeTeam team : this.universe.getTeams()) {
                    FTBUtilitiesTeamData.get((ForgeTeam)team).canForceChunks = FTBUtilitiesLoadedChunkManager.INSTANCE.canForceChunks(team);
                }
                for (ClaimedChunk chunk : this.getAllChunks()) {
                    boolean force;
                    boolean bl = force = chunk.getData().canForceChunks && chunk.isLoaded();
                    if (chunk.forced != null && chunk.forced == force) continue;
                    if (force) {
                        FTBUtilitiesLoadedChunkManager.INSTANCE.forceChunk(server, chunk);
                        continue;
                    }
                    FTBUtilitiesLoadedChunkManager.INSTANCE.unforceChunk(chunk);
                }
            }
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                ChunkDimPos playerPos = new ChunkDimPos((Entity)player);
                int startX = playerPos.posX - 7;
                int startZ = playerPos.posZ - 7;
                new MessageClaimedChunksUpdate(startX, startZ, (EntityPlayer)player).sendTo(player);
                FTBUtilitiesPlayerEventHandler.updateChunkMessage(player, playerPos);
            }
            this.isDirty = false;
        }
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        ClaimedChunk chunk = this.map.get(pos);
        return chunk == null || chunk.isInvalid() ? null : chunk;
    }

    public void removeChunk(ChunkDimPos pos) {
        ClaimedChunk prevChunk = this.map.get(pos);
        if (prevChunk != null) {
            prevChunk.setInvalid();
            this.markDirty();
        }
    }

    public void addChunk(ClaimedChunk chunk) {
        this.pendingChunks.add(chunk);
        chunk.getTeam().markDirty();
        this.markDirty();
    }

    public Collection<ClaimedChunk> getAllChunks() {
        return this.map.isEmpty() ? Collections.emptyList() : this.map.values();
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable ForgeTeam team, OptionalInt dimension, boolean includePending) {
        if (team == null) {
            return Collections.emptySet();
        }
        HashSet<ClaimedChunk> set = new HashSet<ClaimedChunk>();
        for (ClaimedChunk chunk : this.map.values()) {
            if (chunk.isInvalid() || !team.equalsTeam(chunk.getTeam()) || dimension.isPresent() && dimension.getAsInt() != chunk.getPos().dim) continue;
            set.add(chunk);
        }
        if (includePending) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                if (!team.equalsTeam(chunk.getTeam()) || dimension.isPresent() && dimension.getAsInt() != chunk.getPos().dim) continue;
                set.add(chunk);
            }
        }
        return set;
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable ForgeTeam team, OptionalInt dimension) {
        return this.getTeamChunks(team, dimension, false);
    }

    public boolean canPlayerInteract(EntityPlayerMP player, EnumHand hand, BlockPosContainer block, BlockInteractionType type) {
        if (instance == null) {
            return true;
        }
        if (FTBUtilitiesPermissions.canModifyBlock(player, hand, block, type)) {
            return true;
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(block.getPos(), player.field_71093_bK));
        return chunk == null || chunk.getTeam().hasStatus(this.universe.getPlayer((ICommandSender)player), chunk.getData().getStatusFromType(type));
    }

    public boolean canPlayerAttackEntity(EntityPlayerMP player, Entity entity) {
        if (entity instanceof EntityPlayer) {
            if (FTBUtilitiesConfig.world.safe_spawn && player.field_71093_bK == 0 && FTBUtilitiesUniverseData.isInSpawn(player.field_71133_b, new ChunkDimPos(entity))) {
                return false;
            }
            if (FTBUtilitiesConfig.world.enable_pvp.isDefault()) {
                return FTBUtilitiesPlayerData.get(this.universe.getPlayer((ICommandSender)player)).enablePVP() && FTBUtilitiesPlayerData.get(this.universe.getPlayer((ICommandSender)entity)).enablePVP();
            }
            return FTBUtilitiesConfig.world.enable_pvp.isTrue();
        }
        if (!(entity instanceof IMob)) {
            ClaimedChunk chunk = this.getChunk(new ChunkDimPos(entity));
            return chunk == null || chunk.getTeam().hasStatus(this.universe.getPlayer((ICommandSender)player), chunk.getData().getAttackEntitiesStatus());
        }
        return true;
    }

    public boolean canPlayerModify(ForgePlayer player, ChunkDimPos pos, String perm) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return true;
        }
        if (!FTBUtilitiesConfig.world.allowDimension(pos.dim)) {
            return false;
        }
        return player.hasTeam() && chunk.getTeam().equalsTeam(player.team) || player.hasPermission(perm);
    }

    public ClaimResult claimChunk(ForgePlayer player, ChunkDimPos pos, boolean checkLimits) {
        int max;
        if (!player.hasTeam()) {
            return ClaimResult.NO_TEAM;
        }
        if (!FTBUtilitiesConfig.world.allowDimension(pos.dim)) {
            return ClaimResult.DIMENSION_BLOCKED;
        }
        FTBUtilitiesTeamData data = FTBUtilitiesTeamData.get(player.team);
        if (checkLimits && ((max = data.getMaxClaimChunks()) == 0 || this.getTeamChunks(data.team, OptionalInt.empty(), true).size() >= max)) {
            return ClaimResult.NO_POWER;
        }
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk != null) {
            return ClaimResult.ALREADY_CLAIMED;
        }
        chunk = new ClaimedChunk(pos, data);
        this.addChunk(chunk);
        new ChunkModifiedEvent.Claimed(chunk).post();
        return ClaimResult.SUCCESS;
    }

    public boolean unclaimChunk(ChunkDimPos pos) {
        ClaimedChunk chunk = this.map.get(pos);
        if (chunk != null && !chunk.isInvalid()) {
            if (chunk.isLoaded()) {
                new ChunkModifiedEvent.Unloaded(chunk).post();
            }
            chunk.setLoaded(false);
            new ChunkModifiedEvent.Unclaimed(chunk).post();
            this.removeChunk(pos);
            return true;
        }
        return false;
    }

    public void unclaimAllChunks(ForgeTeam team, OptionalInt dim) {
        for (ClaimedChunk chunk : this.getTeamChunks(team, dim)) {
            ChunkDimPos pos = chunk.getPos();
            if (chunk.isLoaded()) {
                new ChunkModifiedEvent.Unloaded(chunk).post();
            }
            chunk.setLoaded(false);
            new ChunkModifiedEvent.Unclaimed(chunk).post();
            this.removeChunk(pos);
        }
    }

    public boolean loadChunk(ForgeTeam team, ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || chunk.isLoaded()) {
            return false;
        }
        if (!FTBUtilitiesConfig.world.allowDimension(pos.dim)) {
            return false;
        }
        int max = FTBUtilitiesTeamData.get(team).getMaxChunkloaderChunks();
        if (max == 0) {
            return false;
        }
        int loadedChunks = 0;
        for (ClaimedChunk c : this.getTeamChunks(team, OptionalInt.empty())) {
            if (!c.isLoaded() || ++loadedChunks < max) continue;
            return false;
        }
        if (chunk.setLoaded(true)) {
            new ChunkModifiedEvent.Loaded(chunk).post();
        }
        return true;
    }

    public boolean unloadChunk(ChunkDimPos pos) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || !chunk.isLoaded()) {
            return false;
        }
        new ChunkModifiedEvent.Unloaded(chunk).post();
        chunk.setLoaded(false);
        return true;
    }
}

