/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.google.gson.JsonElement;
import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Badges {
    private static final String BADGE_URL = "https://badges.latmod.com/get?id=";
    public static final Map<UUID, String> BADGE_CACHE = new HashMap<UUID, String>();
    public static final Map<UUID, String> LOCAL_BADGES = new HashMap<UUID, String>();

    public static void update(UUID playerId) {
        BADGE_CACHE.remove(playerId);
    }

    public static String get(Universe universe, UUID playerId) {
        String badge = BADGE_CACHE.get(playerId);
        if (badge != null) {
            return badge;
        }
        badge = Badges.getRaw(universe, playerId);
        BADGE_CACHE.put(playerId, badge);
        return badge;
    }

    private static String getRaw(Universe universe, UUID playerId) {
        String badge;
        ForgePlayer player;
        block6: {
            player = universe.getPlayer(playerId);
            if (player == null || player.isFake()) {
                return "";
            }
            FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(player);
            if (!data.renderBadge()) {
                return "";
            }
            if (FTBUtilitiesConfig.login.enable_global_badges && !data.disableGlobalBadge()) {
                try {
                    badge = DataReader.get((URL)new URL(BADGE_URL + StringUtils.fromUUID((UUID)playerId)), (String)"text/plain; charset=utf-8", (Proxy)universe.server.func_110454_ao()).string(32);
                    if (!badge.isEmpty()) {
                        return badge;
                    }
                }
                catch (Exception ex) {
                    if (!FTBLibConfig.debugging.print_more_errors) break block6;
                    FTBUtilities.LOGGER.warn("Badge API errored! " + ex);
                }
            }
        }
        return (badge = LOCAL_BADGES.get(playerId)) == null || badge.isEmpty() ? player.getRankConfig(FTBUtilitiesPermissions.BADGE).getString() : badge;
    }

    public static boolean reloadServerBadges(Universe universe) {
        try {
            BADGE_CACHE.clear();
            LOCAL_BADGES.clear();
            File file = new File(CommonUtils.folderLocal, "ftbutilities/server_badges.json");
            if (!file.exists()) {
                file = new File(CommonUtils.folderLocal, "ftbutilities/server_badges.txt");
                if (!file.exists()) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("// For more info see https://guides.latmod.com/ftbutilities/ranks/badges/");
                    list.add("");
                    list.add("uuid: url_to.png");
                    list.add("username: url2_to.png");
                    FileUtils.saveSafe((File)file, list);
                } else {
                    for (String s : DataReader.get((File)file).safeStringList()) {
                        ForgePlayer player;
                        String[] s1;
                        if (s.isEmpty() || s.startsWith("//") || (s1 = s.trim().split(":")).length != 2 || (player = universe.getPlayer((CharSequence)s1[0].trim())) == null) continue;
                        LOCAL_BADGES.put(player.getId(), s1[1].trim());
                    }
                }
            } else {
                for (Map.Entry entry : DataReader.get((File)file).json().getAsJsonObject().entrySet()) {
                    ForgePlayer player = universe.getPlayer((CharSequence)entry.getKey());
                    if (player == null) continue;
                    LOCAL_BADGES.put(player.getId(), ((JsonElement)entry.getValue()).getAsString());
                }
                FileUtils.delete((File)file);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

