/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command;

import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeHelp;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftbutilities.net.MessageEditNBT;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.server.command.CommandTreeBase;

public class CmdEditNBT
extends CmdTreeBase {
    public static Map<UUID, NBTTagCompound> EDITING = new HashMap<UUID, NBTTagCompound>();

    public CmdEditNBT() {
        super("nbtedit");
        this.addSubcommand((ICommand)new CmdTile());
        this.addSubcommand((ICommand)new CmdEntity());
        this.addSubcommand((ICommand)new CmdPlayer());
        this.addSubcommand((ICommand)new CmdTreeHelp((CommandTreeBase)this));
    }

    private static class CmdPlayer
    extends CmdNBT {
        private CmdPlayer() {
            super("player");
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            ForgePlayer p = CommandUtils.getSelfOrOther((ICommandSender)player, (String[])args, (int)0);
            info.func_74757_a("online", p.isOnline());
            info.func_74778_a("type", "player");
            info.func_186854_a("id", p.getId());
            NBTTagCompound nbt = p.getPlayerNBT();
            nbt.func_82580_o("id");
            return nbt;
        }
    }

    private static class CmdEntity
    extends CmdNBT {
        private CmdEntity() {
            super("entity");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 1);
            int id = CmdEntity.func_175755_a((String)args[0]);
            Entity entity = player.field_70170_p.func_73045_a(id);
            NBTTagCompound nbt = new NBTTagCompound();
            if (entity != null) {
                info.func_74778_a("type", "entity");
                info.func_74768_a("id", id);
                entity.func_189511_e(nbt);
            }
            return nbt;
        }
    }

    private static class CmdTile
    extends CmdNBT {
        private CmdTile() {
            super("tile");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 3);
            int x = CmdTile.func_175755_a((String)args[0]);
            int y = CmdTile.func_175755_a((String)args[1]);
            int z = CmdTile.func_175755_a((String)args[2]);
            BlockPos pos = new BlockPos(x, y, z);
            if (!player.field_70170_p.func_175667_e(pos)) {
                throw new CommandException("commands.clone.outOfWorld", new Object[0]);
            }
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            NBTTagCompound nbt = new NBTTagCompound();
            if (tile != null) {
                info.func_74778_a("type", "tile");
                info.func_74768_a("x", x);
                info.func_74768_a("y", y);
                info.func_74768_a("z", z);
                tile.func_189515_b(nbt);
                nbt.func_82580_o("x");
                nbt.func_82580_o("y");
                nbt.func_82580_o("z");
                info.func_74778_a("id", nbt.func_74779_i("id"));
                nbt.func_82580_o("id");
            }
            return nbt;
        }
    }

    public static class CmdNBT
    extends CmdBase {
        private CmdNBT(String id) {
            super(id, CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = CmdNBT.func_71521_c((ICommandSender)sender);
            NBTTagCompound info = new NBTTagCompound();
            NBTTagCompound nbt = this.editNBT(player, info, args);
            if (info.func_74764_b("type")) {
                info.func_74772_a("random", MathUtils.RAND.nextLong());
                EDITING.put(player.func_146103_bH().getId(), info);
                new MessageEditNBT(info, nbt).sendTo(player);
            }
        }

        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            return new NBTTagCompound();
        }
    }
}

