/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command;

import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeBase;
import com.feed_the_beast.ftblib.lib.command.CmdTreeHelp;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.data.backups.Backup;
import com.feed_the_beast.ftbutilities.data.backups.Backups;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.command.CommandTreeBase;

public class CmdBackup
extends CmdTreeBase {
    public CmdBackup() {
        super("backup");
        this.addSubcommand((ICommand)new CmdStart());
        this.addSubcommand((ICommand)new CmdGetSize());
        this.addSubcommand((ICommand)new CmdTime());
        this.addSubcommand((ICommand)new CmdTreeHelp((CommandTreeBase)this));
    }

    public static class CmdTime
    extends CmdBase {
        public CmdTime() {
            super("time", CmdBase.Level.ALL);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            sender.func_145747_a(FTBUtilities.lang(sender, "ftbutilities.lang.timer.backup", StringUtils.getTimeString((long)(Backups.INSTANCE.nextBackup - System.currentTimeMillis()))));
        }
    }

    public static class CmdGetSize
    extends CmdBase {
        public CmdGetSize() {
            super("size", CmdBase.Level.OP);
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("getsize");
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String sizeW = FileUtils.getSizeString((File)server.func_71218_a(0).func_72860_G().func_75765_b());
            long totalSize = 0L;
            for (Backup backup : Backups.INSTANCE.backups) {
                totalSize += backup.size;
            }
            String sizeT = FileUtils.getSizeString((double)totalSize);
            sender.func_145747_a(FTBUtilities.lang(sender, "ftbutilities.lang.backup.size", sizeW, sizeT));
        }
    }

    public static class CmdStart
    extends CmdBase {
        public CmdStart() {
            super("start", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (Backups.INSTANCE.run(server, sender, args.length == 0 ? "" : args[0])) {
                for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                    player.func_145747_a(FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.backup.manual_launch", sender.func_70005_c_()));
                }
            } else {
                sender.func_145747_a(FTBUtilities.lang(sender, "ftbutilities.lang.backup.already_running", new Object[0]));
            }
        }
    }
}

