/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities;

import com.feed_the_beast.ftblib.events.RegisterPermissionsEvent;
import com.feed_the_beast.ftblib.events.RegisterRankConfigEvent;
import com.feed_the_beast.ftblib.events.RegisterRankConfigHandlerEvent;
import com.feed_the_beast.ftblib.lib.EventHandler;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IRankConfigHandler;
import com.feed_the_beast.ftblib.lib.math.BlockPosContainer;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.BlockInteractionType;
import com.feed_the_beast.ftbutilities.data.Leaderboard;
import com.feed_the_beast.ftbutilities.events.CustomPermissionPrefixesRegistryEvent;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;

@EventHandler
public class FTBUtilitiesPermissions {
    public static final String DISPLAY_ADMIN_INFO = "ftbutilities.display.admin_info";
    public static final Node BADGE = Node.get((String)"ftbutilities.badge");
    public static final String HOMES_CROSS_DIM = "ftbutilities.homes.cross_dim";
    public static final Node HOMES_MAX = Node.get((String)"ftbutilities.homes.max");
    public static final Node HOMES_COOLDOWN = Node.get((String)"ftbutilities.homes.cooldown");
    public static final Node HOMES_WARMUP = Node.get((String)"ftbutilities.homes.warmup");
    public static final String HOMES_LIST_OTHER = "ftbutilities.other_player.homes.list";
    public static final String HOMES_TELEPORT_OTHER = "ftbutilities.other_player.homes.teleport";
    public static final Node WARPS_COOLDOWN = Node.get((String)"ftbutilities.warps.cooldown");
    public static final Node WARPS_WARMUP = Node.get((String)"ftbutilities.warps.warmup");
    public static final String CLAIMS_OTHER_SEE_INFO = "ftbutilities.other_player.claims.see_info";
    public static final String CLAIMS_OTHER_CLAIM = "ftbutilities.other_player.claims.claim";
    public static final String CLAIMS_OTHER_UNCLAIM = "ftbutilities.other_player.claims.unclaim";
    public static final String CLAIMS_OTHER_LOAD = "ftbutilities.other_player.claims.load";
    public static final String CLAIMS_OTHER_UNLOAD = "ftbutilities.other_player.claims.unload";
    public static final Node CLAIMS_MAX_CHUNKS = Node.get((String)"ftbutilities.claims.max_chunks");
    public static final String CLAIMS_BLOCK_CNB = "ftbutilities.claims.block.cnb";
    private static final String CLAIMS_BLOCK_EDIT_PREFIX = "ftbutilities.claims.block.edit.";
    private static final String CLAIMS_BLOCK_INTERACT_PREFIX = "ftbutilities.claims.block.interact.";
    private static final String CLAIMS_ITEM_PREFIX = "ftbutilities.claims.item.";
    public static final Node CHUNKLOADER_MAX_CHUNKS = Node.get((String)"ftbutilities.chunkloader.max_chunks");
    public static final String CHUNKLOADER_LOAD_OFFLINE = "ftbutilities.chunkloader.load_offline";
    public static final Node CHAT = Node.get((String)"ftbutilities.chat");
    public static final Node CHAT_PREFIX_PART_COUNT = CHAT.append("prefix.part_count");
    public static final ChatPart CHAT_PREFIX = new ChatPart("prefix");
    public static final ChatPart CHAT_NAME = new ChatPart("name");
    public static final Node CHAT_SUFFIX_PART_COUNT = CHAT.append("suffix.part_count");
    public static final ChatPart CHAT_SUFFIX = new ChatPart("suffix");
    public static final ChatPart CHAT_TEXT = new ChatPart("text");
    public static final String INFINITE_BACK_USAGE = "ftbutilities.back.infinite";
    public static final String VIEW_CRASH_REPORTS = "admin_panel.ftbutilities.crash_reports.view";
    public static final String DELETE_CRASH_REPORTS = "admin_panel.ftbutilities.crash_reports.delete";
    private static final String LEADERBOARD_PREFIX = "ftbutilities.leaderboard.";
    public static final String EDIT_WORLD_GAMERULES = "admin_panel.ftbutilities.edit_world.gamerules";
    public static final Node TPA_COOLDOWN = Node.get((String)"ftbutilities.tpa.cooldown");
    public static final Node SPAWN_COOLDOWN = Node.get((String)"ftbutilities.spawn.cooldown");
    public static final Node BACK_COOLDOWN = Node.get((String)"ftbutilities.back.cooldown");
    public static final Node TPA_WARMUP = Node.get((String)"ftbutilities.tpa.warmup");
    public static final Node SPAWN_WARMUP = Node.get((String)"ftbutilities.spawn.warmup");
    public static final Node BACK_WARMUP = Node.get((String)"ftbutilities.back.warmup");
    public static final String TPA_CROSS_DIM = "ftbutilities.tpa.cross_dim";
    public static final String NICKNAME_SET = "ftbutilities.nickname.set";
    public static final String NICKNAME_COLORS = "ftbutilities.nickname.colors";
    public static final Node AFK_TIMER = Node.get((String)"ftbutilities.afk.timer");
    public static final String HEAL_OTHER = "ftbutilities.other_player.heal";

    @SubscribeEvent
    public static void registerRankConfigHandler(RegisterRankConfigHandlerEvent event) {
        if (FTBUtilitiesConfig.ranks.enabled) {
            event.setHandler((IRankConfigHandler)FTBUtilitiesPermissionHandler.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerPermissions(RegisterPermissionsEvent event) {
        String name;
        event.registerNode(DISPLAY_ADMIN_INFO, DefaultPermissionLevel.OP, "Display 'Admin' in Server Info");
        event.registerNode(HOMES_CROSS_DIM, DefaultPermissionLevel.ALL, "Can use /home to teleport to/from another dimension");
        event.registerNode(HOMES_LIST_OTHER, DefaultPermissionLevel.OP, "Allow to list other people homes");
        event.registerNode(HOMES_TELEPORT_OTHER, DefaultPermissionLevel.OP, "Allow to teleport to other people homes");
        event.registerNode(CLAIMS_OTHER_SEE_INFO, DefaultPermissionLevel.OP, "Allow player to see info of other team chunks");
        event.registerNode(CLAIMS_OTHER_CLAIM, DefaultPermissionLevel.OP, "Allow player to claim other team chunks");
        event.registerNode(CLAIMS_OTHER_UNCLAIM, DefaultPermissionLevel.OP, "Allow player to unclaim other team chunks");
        event.registerNode(CLAIMS_OTHER_LOAD, DefaultPermissionLevel.OP, "Allow player to load other team chunks");
        event.registerNode(CLAIMS_OTHER_UNLOAD, DefaultPermissionLevel.OP, "Allow player to unload other team chunks");
        event.registerNode(CLAIMS_BLOCK_CNB, DefaultPermissionLevel.OP, "Allow to edit C&B bits in claimed chunks");
        event.registerNode(CHUNKLOADER_LOAD_OFFLINE, DefaultPermissionLevel.ALL, "Keep loaded chunks working when player goes offline");
        event.registerNode(INFINITE_BACK_USAGE, DefaultPermissionLevel.NONE, "Allow to use 'back' command infinite times");
        event.registerNode(VIEW_CRASH_REPORTS, DefaultPermissionLevel.OP, "Allow to view crash reports via Admin Panel");
        event.registerNode(DELETE_CRASH_REPORTS, DefaultPermissionLevel.OP, "Allow to delete crash reports, requires admin_panel.ftbutilities.crash_reports.view");
        event.registerNode(EDIT_WORLD_GAMERULES, DefaultPermissionLevel.OP, "Allow to edit gamerules via Admin Panel");
        event.registerNode(TPA_CROSS_DIM, DefaultPermissionLevel.ALL, "Can use /tpa to teleport to/from another dimension");
        event.registerNode(NICKNAME_SET, DefaultPermissionLevel.OP, "Allow to change nickname");
        event.registerNode(NICKNAME_COLORS, DefaultPermissionLevel.OP, "Allow to use formatting codes in nickname, requires ftbutilities.nickname.set");
        for (Block block : Block.field_149771_c) {
            name = FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block);
            event.registerNode(CLAIMS_BLOCK_EDIT_PREFIX + name, name.startsWith("graves.") || name.startsWith("gravestone.") ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP);
            event.registerNode(CLAIMS_BLOCK_INTERACT_PREFIX + name, block instanceof BlockDoor || block instanceof BlockWorkbench || block instanceof BlockAnvil ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP);
        }
        for (Item item : Item.field_150901_e) {
            name = FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)item);
            event.registerNode(CLAIMS_ITEM_PREFIX + name, item instanceof ItemBucket ? DefaultPermissionLevel.OP : DefaultPermissionLevel.ALL);
        }
        event.registerNode("ftbutilities.claims.block.edit.gravestone.gravestone", DefaultPermissionLevel.ALL);
        event.registerNode("ftbutilities.claims.block.edit.openblocks.grave", DefaultPermissionLevel.ALL);
        event.registerNode(CLAIMS_ITEM_PREFIX + FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)Items.field_185158_cP), DefaultPermissionLevel.OP);
        event.registerNode("ftbutilities.claims.item.forge.bucketfilled", DefaultPermissionLevel.OP);
        for (Leaderboard leaderboard : FTBUtilitiesCommon.LEADERBOARDS.values()) {
            event.registerNode(FTBUtilitiesPermissions.getLeaderboardNode(leaderboard), DefaultPermissionLevel.ALL);
        }
    }

    @SubscribeEvent
    public static void registerConfigs(RegisterRankConfigEvent event) {
        event.register(BADGE, (ConfigValue)new ConfigString(""));
        event.register(HOMES_MAX, (ConfigValue)new ConfigInt(1, 0, 30000), (ConfigValue)new ConfigInt(100));
        event.register(HOMES_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.mt((long)5L)), (ConfigValue)new ConfigTimer(0L));
        event.register(WARPS_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(TPA_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.mt((long)3L)), (ConfigValue)new ConfigTimer(0L));
        event.register(SPAWN_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(BACK_COOLDOWN, (ConfigValue)new ConfigTimer(Ticks.mt((long)3L)), (ConfigValue)new ConfigTimer(0L));
        event.register(HOMES_WARMUP, (ConfigValue)new ConfigTimer(Ticks.st((long)5L), Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(WARPS_WARMUP, (ConfigValue)new ConfigTimer(Ticks.st((long)5L), Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(TPA_WARMUP, (ConfigValue)new ConfigTimer(Ticks.st((long)5L), Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(SPAWN_WARMUP, (ConfigValue)new ConfigTimer(Ticks.st((long)5L), Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(BACK_WARMUP, (ConfigValue)new ConfigTimer(Ticks.st((long)5L), Ticks.mt((long)1L)), (ConfigValue)new ConfigTimer(0L));
        event.register(CLAIMS_MAX_CHUNKS, (ConfigValue)new ConfigInt(100, 0, 30000), (ConfigValue)new ConfigInt(1000));
        event.register(CHUNKLOADER_MAX_CHUNKS, (ConfigValue)new ConfigInt(50, 0, 30000), (ConfigValue)new ConfigInt(64));
        event.register(AFK_TIMER, (ConfigValue)new ConfigTimer(0L));
    }

    @SubscribeEvent
    public static void registerCustomPermissionPrefixes(CustomPermissionPrefixesRegistryEvent event) {
        event.register(Node.COMMAND, DefaultPermissionLevel.OP, "Permission for commands, if FTBUtilities command overriding is enabled. If not, this node will be inactive");
        event.register(Node.get((String)CLAIMS_BLOCK_EDIT_PREFIX), DefaultPermissionLevel.OP, "Permission for blocks that players can break and place within claimed chunks");
        event.register(Node.get((String)CLAIMS_BLOCK_INTERACT_PREFIX), DefaultPermissionLevel.OP, "Permission for blocks that players can right-click within claimed chunks");
        event.register(Node.get((String)CLAIMS_ITEM_PREFIX), DefaultPermissionLevel.ALL, "Permission for items that players can right-click in air within claimed chunks");
        event.register(Node.get((String)LEADERBOARD_PREFIX), DefaultPermissionLevel.ALL, "Permission for leaderboards that players can view");
    }

    private static String formatId(@Nullable IForgeRegistryEntry item) {
        return item == null || item.getRegistryName() == null ? "minecraft.air" : item.getRegistryName().toString().toLowerCase().replace(':', '.');
    }

    public static boolean canModifyBlock(EntityPlayerMP player, EnumHand hand, BlockPosContainer block, BlockInteractionType type) {
        BlockPosContext context = new BlockPosContext((EntityPlayer)player, block.getPos(), block.getState(), null);
        switch (type) {
            case EDIT: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_BLOCK_EDIT_PREFIX + FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block.getState().func_177230_c())), (IContext)context);
            }
            case INTERACT: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_BLOCK_INTERACT_PREFIX + FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)block.getState().func_177230_c())), (IContext)context);
            }
            case CNB_BREAK: 
            case CNB_PLACE: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)CLAIMS_BLOCK_CNB, (IContext)context);
            }
            case ITEM: {
                return !player.func_184586_b(hand).func_190926_b() || PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_ITEM_PREFIX + FTBUtilitiesPermissions.formatId((IForgeRegistryEntry)player.func_184586_b(hand).func_77973_b())), (IContext)context);
            }
        }
        return false;
    }

    public static String getLeaderboardNode(Leaderboard leaderboard) {
        return LEADERBOARD_PREFIX + leaderboard.id.func_110624_b() + "." + leaderboard.id.func_110623_a();
    }

    public static class ChatPart {
        public final Node color;
        public final Node text;
        public final Node bold;
        public final Node italic;
        public final Node underlined;
        public final Node strikethrough;
        public final Node obfuscated;

        public ChatPart(String s) {
            Node node = CHAT.append(s);
            this.color = node.append("color");
            this.text = node.append("text");
            this.bold = node.append("bold");
            this.italic = node.append("italic");
            this.underlined = node.append("underlined");
            this.strikethrough = node.append("strikethrough");
            this.obfuscated = node.append("obfuscated");
        }

        public ITextComponent format(Rank rank, ITextComponent component, @Nullable ChatPart alt) {
            JsonElement json;
            TextFormatting colortf = TextFormatting.WHITE;
            if (alt != null && (json = rank.getConfigRaw(alt.color)).isJsonPrimitive()) {
                colortf = (TextFormatting)StringUtils.TEXT_FORMATTING_COLORS_NAME_MAP.get(json.getAsString());
            }
            if ((json = rank.getConfigRaw(this.color)).isJsonPrimitive()) {
                colortf = (TextFormatting)StringUtils.TEXT_FORMATTING_COLORS_NAME_MAP.get(json.getAsString());
            }
            if (colortf != TextFormatting.WHITE) {
                component.func_150256_b().func_150238_a(colortf);
            }
            if (this.getStyleBoolean(rank, this.bold, alt == null ? null : alt.bold)) {
                component.func_150256_b().func_150227_a(Boolean.valueOf(true));
            }
            if (this.getStyleBoolean(rank, this.italic, alt == null ? null : alt.italic)) {
                component.func_150256_b().func_150217_b(Boolean.valueOf(true));
            }
            if (this.getStyleBoolean(rank, this.underlined, alt == null ? null : alt.underlined)) {
                component.func_150256_b().func_150228_d(Boolean.valueOf(true));
            }
            if (this.getStyleBoolean(rank, this.strikethrough, alt == null ? null : alt.strikethrough)) {
                component.func_150256_b().func_150225_c(Boolean.valueOf(true));
            }
            if (this.getStyleBoolean(rank, this.obfuscated, alt == null ? null : alt.obfuscated)) {
                component.func_150256_b().func_150237_e(Boolean.valueOf(true));
            }
            return component;
        }

        private boolean getStyleBoolean(Rank rank, Node main, @Nullable Node alt) {
            Event.Result result = rank.getPermissionRaw(main, false);
            if (result == Event.Result.DEFAULT && alt != null) {
                result = rank.getPermissionRaw(alt, false);
            }
            return result == Event.Result.ALLOW;
        }
    }
}

