/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.api.utils.BlockCoords;
import sonar.core.utils.IWorldPosition;
import sonar.core.utils.SortingDirection;

public class SonarHelper {
    private static List<EnumFacing> face_values;

    public static List<EnumFacing> getEnumFacingValues() {
        return face_values == null ? (face_values = SonarHelper.convertArray(EnumFacing.field_82609_l)) : face_values;
    }

    public static ChunkPos getChunkFromPos(int xPos, int zPos) {
        return new ChunkPos(xPos >> 4, zPos >> 4);
    }

    public static ChunkPos getChunkPos(int xChunk, int zChunk) {
        return new ChunkPos(xChunk, zChunk);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tile, EnumFacing side) {
        return tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(side));
    }

    public static Block getAdjacentBlock(World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c();
    }

    public static Entity getEntity(Class entityClass, IWorldPosition tile, int range, boolean nearest) {
        BlockCoords coords = tile.getCoords();
        AxisAlignedBB aabb = new AxisAlignedBB((double)(coords.getX() - range), (double)(coords.getY() - range), (double)(coords.getZ() - range), (double)(coords.getX() + range), (double)(coords.getY() + range), (double)(coords.getZ() + range));
        List entities = coords.getWorld().func_72872_a(entityClass, aabb);
        Entity entity = null;
        double entityDis = nearest ? Double.MAX_VALUE : 0.0;
        for (Entity target : entities) {
            double d0 = (double)coords.getX() - target.field_70165_t;
            double d1 = (double)coords.getY() - target.field_70163_u;
            double d2 = (double)coords.getZ() - target.field_70161_v;
            double distance = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(nearest ? distance < entityDis : distance > entityDis)) continue;
            entity = target;
            entityDis = distance;
        }
        return entity;
    }

    public static EntityPlayerMP getPlayerFromName(String player) {
        List server = FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_184103_al().func_181057_v();
        for (EntityPlayerMP entityPlayer : server) {
            if (!entityPlayer.func_70005_c_().equals(player)) continue;
            return entityPlayer;
        }
        return null;
    }

    public static EntityPlayer getPlayerFromUUID(UUID player) {
        EntityPlayer fromUUID = null;
        Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(player);
        if (entity instanceof EntityPlayer) {
            fromUUID = (EntityPlayer)entity;
        }
        return fromUUID;
    }

    public static GameProfile getProfileByUUID(UUID playerUUID) {
        if (playerUUID == null) {
            return new GameProfile(UUID.randomUUID(), "ERROR: UUID IS INCORRECT");
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(playerUUID);
        }
        return new GameProfile(playerUUID, UsernameCache.containsUUID((UUID)playerUUID) ? UsernameCache.getLastKnownUsername((UUID)playerUUID) : "PLAYER ERROR!");
    }

    public static GameProfile getGameProfileForUsername(String playerName) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(playerName);
    }

    public static EnumFacing getForward(int meta) {
        return EnumFacing.func_82600_a((int)meta).func_176735_f();
    }

    public static int getAngleFromMeta(int meta) {
        switch (meta) {
            case 2: {
                return 180;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 270;
            }
        }
        return 0;
    }

    public static int invertMetadata(int meta) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public static ItemStack createStackedBlock(Block block, int meta) {
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        Item item = Item.func_150898_a((Block)block);
        int j = 0;
        if (item.func_77614_k()) {
            j = meta;
        }
        return new ItemStack(item, 1, j);
    }

    public static EnumFacing offsetFacing(EnumFacing facing, EnumFacing front) {
        if (facing.func_176740_k().func_176716_d() == EnumFacing.Plane.VERTICAL || front.func_176740_k().func_176716_d() == EnumFacing.Plane.VERTICAL) {
            return facing;
        }
        return EnumFacing.func_176733_a((double)(SonarHelper.getRenderRotation(front) + SonarHelper.getRenderRotation(facing))).func_176734_d();
    }

    public static int getRenderRotation(EnumFacing face) {
        switch (face) {
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
            case EAST: {
                return 90;
            }
        }
        return 0;
    }

    public static EnumFacing getHorizontal(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return EnumFacing.EAST;
        }
        if (dir == EnumFacing.EAST) {
            return EnumFacing.SOUTH;
        }
        if (dir == EnumFacing.SOUTH) {
            return EnumFacing.WEST;
        }
        if (dir == EnumFacing.WEST) {
            return EnumFacing.NORTH;
        }
        return dir;
    }

    public static ArrayList<BlockCoords> getConnectedBlocks(Block block, List<EnumFacing> dirs, World w, BlockPos pos, int max) {
        ArrayList<BlockCoords> handlers = new ArrayList<BlockCoords>();
        SonarHelper.addCoords(block, w, pos, max, handlers, dirs);
        return handlers;
    }

    public static void addCoords(Block block, World w, BlockPos pos, int max, ArrayList<BlockCoords> handlers, List<EnumFacing> dirs) {
        for (EnumFacing side : dirs) {
            BlockCoords coords;
            if (handlers.size() > max) {
                return;
            }
            BlockPos current = pos.func_177972_a(side);
            IBlockState state = w.func_180495_p(current);
            Block tile = w.func_180495_p(current).func_177230_c();
            if (tile != block || handlers.contains(coords = new BlockCoords(current))) continue;
            handlers.add(coords);
            SonarHelper.addCoords(block, w, current, max, handlers, SonarHelper.convertArray(EnumFacing.values()));
        }
    }

    public static <E extends Enum> E incrementEnum(E enumObj, E[] values) {
        int ordinal = enumObj.ordinal() + 1;
        if (ordinal < values.length) {
            return values[ordinal];
        }
        return values[0];
    }

    public static <T> List<T> convertArray(T[] objs) {
        ArrayList inputs = new ArrayList();
        Collections.addAll(inputs, objs);
        return inputs;
    }

    public static <T> T[] convertArray(List<T> objs) {
        return objs.toArray();
    }

    public static boolean intContains(int[] ints, int num) {
        for (int i : ints) {
            if (i != num) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean arrayContains(T[] ints, T num) {
        for (T i : ints) {
            if (i != num) continue;
            return true;
        }
        return false;
    }

    public static int compareWithDirection(long stored1, long stored2, SortingDirection dir) {
        if (stored1 < stored2) {
            return dir == SortingDirection.DOWN ? 1 : -1;
        }
        if (stored1 == stored2) {
            return 0;
        }
        return dir == SortingDirection.DOWN ? -1 : 1;
    }

    public static int compareStringsWithDirection(String string1, String string2, SortingDirection dir) {
        int res = String.CASE_INSENSITIVE_ORDER.compare(string1, string2);
        if (res == 0) {
            res = string1.compareTo(string2);
        }
        return dir == SortingDirection.DOWN ? res : -res;
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(PlayerChunkMapEntry entry) {
        if (entry != null && entry.func_187274_e()) {
            try {
                Field field = PlayerChunkMapEntry.class.getDeclaredField("players");
                field.setAccessible(true);
                List obj = (List)field.get(entry);
                return Lists.newArrayList((Iterable)obj);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return new ArrayList<EntityPlayerMP>();
    }

    @Nullable
    public static EnumFacing getBlockDirection(BlockPos main, BlockPos dirPos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!main.func_177972_a(face).equals((Object)dirPos)) continue;
            return face;
        }
        return null;
    }
}

