/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.Logger;
import sonar.core.SonarCore;
import sonar.core.api.asm.FluidHandler;
import sonar.core.api.asm.ItemEnergyHandler;
import sonar.core.api.asm.TileEnergyHandler;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.energy.ITileEnergyHandler;
import sonar.core.api.fluids.ISonarFluidHandler;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.Pair;
import sonar.core.utils.SortingDirection;

public class ASMLoader {
    public static Comparator<ASMDataTable.ASMData> SORT_PRIORITY = (str1, str2) -> SonarHelper.compareWithDirection(((Integer)str1.getAnnotationInfo().get("priority")).intValue(), ((Integer)str2.getAnnotationInfo().get("priority")).intValue(), SortingDirection.UP);

    public static void load(@Nonnull ASMDataTable asmDataTable) {
        SonarCore.tileEnergyHandlers = ASMLoader.getTileEnergyHandlers(SonarCore.logger, asmDataTable);
        SonarCore.fluidHandlers = ASMLoader.getFluidHandlers(SonarCore.logger, asmDataTable);
        SonarCore.itemEnergyHandlers = ASMLoader.getItemEnergyHandlers(SonarCore.logger, asmDataTable);
    }

    public static List<ITileEnergyHandler> getTileEnergyHandlers(Logger logger, @Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(logger, asmDataTable, TileEnergyHandler.class, ITileEnergyHandler.class, true, true);
    }

    public static List<ISonarFluidHandler> getFluidHandlers(Logger logger, @Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(logger, asmDataTable, FluidHandler.class, ISonarFluidHandler.class, true, true);
    }

    public static List<IItemEnergyHandler> getItemEnergyHandlers(Logger logger, @Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances(logger, asmDataTable, ItemEnergyHandler.class, IItemEnergyHandler.class, true, true);
    }

    public static void log(Logger logger, ASMLog log, Class type, ASMDataTable.ASMData asm, String modid) {
        switch (log) {
            case ERROR: {
                logger.error(type.getSimpleName() + " couldn't be loaded as an error occurred - please report to mod author: " + asm.getClassName());
                break;
            }
            case LOADED: {
                logger.info(type.getSimpleName() + " loaded successfully: " + asm.getClassName());
                break;
            }
            case MODID: {
                logger.info("Couldn't load " + type.getSimpleName() + " " + asm.getClassName() + " for modid " + modid);
                break;
            }
        }
    }

    public static <T> List<T> getInstances(Logger logger, @Nonnull ASMDataTable asmDataTable, Class annotation, Class<T> instanceClass, boolean checkModid, boolean sortPriority) {
        ArrayList<T> instances = new ArrayList<T>();
        String annotationClassName = annotation.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<ASMDataTable.ASMData> data = new ArrayList<ASMDataTable.ASMData>(asmDatas);
        if (sortPriority) {
            data.sort(SORT_PRIORITY);
        }
        for (ASMDataTable.ASMData asmData : data) {
            String modid;
            String string = modid = checkModid ? (String)asmData.getAnnotationInfo().get("modid") : "";
            if (!checkModid || Loader.isModLoaded((String)modid) || Loader.isModLoaded((String)modid.toLowerCase())) {
                try {
                    Class<?> asmClass = Class.forName(asmData.getClassName());
                    Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                    T instance = asmInstanceClass.newInstance();
                    instances.add(instance);
                    ASMLoader.log(logger, ASMLog.LOADED, instanceClass, asmData, modid);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    ASMLoader.log(logger, ASMLog.ERROR, instanceClass, asmData, modid);
                }
                continue;
            }
            ASMLoader.log(logger, ASMLog.MODID, instanceClass, asmData, modid);
        }
        return instances;
    }

    public static <T> void injectInstances(Logger logger, ASMDataTable data, Class annotation, Class<T> instanceClass, Function<ASMDataTable.ASMData, T> create) {
        for (ASMDataTable.ASMData entry : data.getAll(annotation.getName())) {
            String targetClass = entry.getClassName();
            String targetName = entry.getObjectName();
            T i = create.apply(entry);
            if (i == null) {
                return;
            }
            try {
                Field field = Class.forName(targetClass).getDeclaredField(targetName);
                if ((field.getModifiers() & 8) != 8) {
                    logger.warn("Unable to inject instance %s at %s.%s (Non-Static)", (Object)i.toString(), (Object)targetClass, (Object)targetName);
                }
                EnumHelper.setFailsafeFieldValue((Field)field, null, i);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warn("Unable to inject instance %s at %s.%s", (Object)i.toString(), (Object)targetClass, (Object)targetName);
            }
        }
    }

    public static <T> List<Pair<ASMDataTable.ASMData, Class<? extends T>>> getClasses(Logger logger, @Nonnull ASMDataTable asmDataTable, Class annotation, Class<T> instanceClass, boolean checkModid) {
        String annotationClassName = annotation.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<Pair<ASMDataTable.ASMData, Class<T>>> classes = new ArrayList<Pair<ASMDataTable.ASMData, Class<T>>>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            String modid;
            String string = modid = checkModid ? (String)asmData.getAnnotationInfo().get("modid") : "";
            if (!checkModid || Loader.isModLoaded((String)modid) || Loader.isModLoaded((String)modid.toLowerCase())) {
                try {
                    Class<?> asmClass = Class.forName(asmData.getClassName());
                    Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                    classes.add(new Pair<ASMDataTable.ASMData, Class<T>>(asmData, asmInstanceClass));
                    ASMLoader.log(logger, ASMLog.LOADED, instanceClass, asmData, modid);
                }
                catch (ClassNotFoundException e) {
                    ASMLoader.log(logger, ASMLog.ERROR, instanceClass, asmData, modid);
                }
                continue;
            }
            ASMLoader.log(logger, ASMLog.MODID, instanceClass, asmData, modid);
        }
        return classes;
    }

    public static enum ASMLog {
        LOADED,
        ERROR,
        MODID;

    }
}

