/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import sonar.core.handlers.energy.DischargeValues;
import sonar.core.handlers.energy.EnergyTransferHandler;
import sonar.core.handlers.inventories.containers.ContainerSonar;

public class TransferSlotsManager<T extends IInventory> {
    public static TransferSlotsManager<IInventory> DEFAULT = new TransferSlotsManager<IInventory>(){
        {
            this.addPlayerInventory();
        }
    };
    public static TransferSlots DISCHARGE_SLOT = new TransferSlots<IInventory>(TransferType.TILE_INV, 1){

        @Override
        public boolean canInsert(EntityPlayer player, IInventory inv, Slot slot, int pos, int slotID, ItemStack stack) {
            return DischargeValues.getValueOf(stack) > 0 || EnergyTransferHandler.INSTANCE_SC.getItemHandler(stack) != null;
        }
    };
    private List<TransferSlots<T>> slots = new ArrayList<TransferSlots<T>>();
    public int current;
    public int playerInvStart;
    public int playerInvEnd;
    public boolean hasPlayerInv;

    public TransferSlotsManager() {
    }

    public TransferSlotsManager(int tileSize) {
        this.addTransferSlot(new TransferSlots(TransferType.TILE_INV, tileSize));
        this.addPlayerInventory();
    }

    public void addTransferSlot(TransferSlots transferSlots) {
        transferSlots.start = this.current;
        transferSlots.end = this.current + transferSlots.size;
        this.current += transferSlots.size;
        this.slots.add(transferSlots);
    }

    public void addPlayerInventory() {
        this.playerInvStart = this.current;
        this.addTransferSlot(new TransferSlots(TransferType.PLAYER_INV, 27));
        this.addTransferSlot(new TransferSlots(TransferType.PLAYER_HOTBAR, 9));
        this.playerInvEnd = this.current;
        this.hasPlayerInv = true;
    }

    public void addPlayerMainInventory() {
        this.playerInvStart = this.current;
        this.addTransferSlot(new TransferSlots(TransferType.PLAYER_INV, 27));
        this.playerInvEnd = this.current;
        this.hasPlayerInv = true;
    }

    public void addPlayerHotbar() {
        this.playerInvStart = this.current;
        this.addTransferSlot(new TransferSlots(TransferType.PLAYER_HOTBAR, 9));
        this.playerInvEnd = this.current;
        this.hasPlayerInv = true;
    }

    public TransferSlots<T> getTransferSettings(int slotID) {
        for (TransferSlots<T> slot : this.slots) {
            if (slot.start > slotID || slot.end <= slotID) continue;
            return slot;
        }
        return this.slots.get(this.slots.size() - 1);
    }

    public ItemStack transferStackInSlot(ContainerSonar c, T inv, EntityPlayer player, int slotID) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)c.field_75151_b.get(slotID);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            TransferSlots<T> settings = this.getTransferSettings(slotID);
            if (settings.type.isPlayerInv()) {
                for (TransferSlots<T> tileSlots : this.slots) {
                    if (tileSlots == settings || !tileSlots.canInsert(player, inv, slot, slotID - tileSlots.start, slotID, itemstack1) || c.mergeSonarStack(itemstack1, tileSlots.start, tileSlots.end, false)) continue;
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (this.hasPlayerInv && !c.mergeSonarStack(itemstack1, this.playerInvStart, this.playerInvEnd, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    public static class TransferSlots<T extends IInventory> {
        public TransferType type;
        public int start;
        public int end;
        public int size;

        public TransferSlots(TransferType type, int size) {
            this.type = type;
            this.size = size;
        }

        public boolean canInsert(EntityPlayer player, T inv, Slot slot, int pos, int slotID, ItemStack stack) {
            return true;
        }
    }

    public static class TransferSlotsValid<T extends IInventory>
    extends TransferSlots<T> {
        public TransferSlotsValid(TransferType type, int size) {
            super(type, size);
        }

        @Override
        public boolean canInsert(EntityPlayer player, T inv, Slot slot, int pos, int slotID, ItemStack stack) {
            return slot.func_75214_a(stack);
        }
    }

    public static class DisabledSlots<T extends IInventory>
    extends TransferSlots<T> {
        public DisabledSlots(TransferType type, int size) {
            super(type, size);
        }

        @Override
        public boolean canInsert(EntityPlayer player, T inv, Slot slot, int pos, int slotID, ItemStack stack) {
            return false;
        }
    }

    public static enum TransferType {
        TILE_INV,
        PLAYER_INV,
        PLAYER_HOTBAR;


        public boolean isPlayerInv() {
            return this != TILE_INV;
        }
    }
}

