/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.x3d;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import thut.api.entity.IMobColourable;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelCustom;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.model.IRetexturableModel;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;
import thut.core.client.render.x3d.Material;
import thut.core.client.render.x3d.Shape;
import thut.core.client.render.x3d.X3dObject;
import thut.core.client.render.x3d.X3dXML;

public class X3dModel
implements IModelCustom,
IModel,
IRetexturableModel {
    public HashMap<String, IExtendedModelPart> parts = new HashMap();
    Map<String, Material> mats = Maps.newHashMap();
    Set<String> heads = Sets.newHashSet();
    final IModel.HeadInfo info = new IModel.HeadInfo();
    public String name;

    public X3dModel() {
    }

    public X3dModel(ResourceLocation l) {
        this();
        this.loadModel(l);
    }

    private void addChildren(Set<X3dXML.Transform> allTransforms, X3dXML.Transform transform) {
        for (X3dXML.Transform f : transform.transforms) {
            if (f.DEF.contains("ifs_TRANSFORM")) continue;
            allTransforms.add(f);
            this.addChildren(allTransforms, f);
        }
    }

    private Material getMaterial(X3dXML.Appearance appearance) {
        X3dXML.Material mat = appearance.material;
        if (mat == null) {
            return null;
        }
        String matName = mat.DEF;
        boolean isDef = matName != null;
        Material material = this.mats.get(matName = matName == null ? mat.USE.substring(3) : matName.substring(3));
        if (material == null || isDef) {
            String texName;
            if (appearance.tex != null && appearance.tex.DEF != null) {
                texName = appearance.tex.DEF.substring(3);
                if (texName.contains("_png")) {
                    texName = texName.substring(0, texName.lastIndexOf("_png"));
                }
            } else {
                texName = null;
            }
            if (material == null) {
                material = new Material(matName, texName, mat.getDiffuse(), mat.getSpecular(), mat.getEmissive(), mat.ambientIntensity, mat.shininess, mat.transparency);
            }
            if (isDef) {
                if (material.texture == null) {
                    material.texture = texName;
                }
                material.ambientIntensity = mat.ambientIntensity;
                material.shininess = mat.shininess;
                material.transparency = mat.transparency;
                material.emissiveColor = mat.getEmissive();
                material.specularColor = mat.getSpecular();
                material.diffuseColor = mat.getDiffuse();
                material.emissiveMagnitude = Math.min(1.0f, (float)((double)mat.getEmissive().length() / Math.sqrt(3.0)) / 0.8f);
            }
            this.mats.put(matName, material);
        }
        return material;
    }

    @Override
    public HashMap<String, IExtendedModelPart> getParts() {
        return this.parts;
    }

    public void loadModel(ResourceLocation model) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(model);
            X3dXML xml = new X3dXML(res.func_110527_b());
            res.close();
            this.makeObjects(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    HashMap<String, IExtendedModelPart> makeObjects(X3dXML xml) throws Exception {
        HashMap childMap = Maps.newHashMap();
        HashSet allTransforms = Sets.newHashSet();
        for (X3dXML.Transform transform : xml.model.scene.transforms) {
            allTransforms.add(transform);
            this.addChildren(allTransforms, transform);
        }
        for (X3dXML.Transform transform : allTransforms) {
            String[] offset = transform.translation.split(" ");
            Vector3 translation = Vector3.getNewVector().set(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.scale.split(" ");
            Vertex scale = new Vertex(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]));
            offset = transform.rotation.split(" ");
            Vector4 rotations = new Vector4(Float.parseFloat(offset[0]), Float.parseFloat(offset[1]), Float.parseFloat(offset[2]), (float)Math.toDegrees(Float.parseFloat(offset[3])));
            Set<String> children = transform.getChildNames();
            X3dXML.Transform transform2 = transform.getIfsTransform();
            if (transform2 == null) continue;
            X3dXML.Group group = transform2.group;
            String name = transform2.getGroupName();
            ArrayList shapes = Lists.newArrayList();
            for (X3dXML.Shape shape : group.shapes) {
                X3dXML.IndexedTriangleSet triangleSet = shape.triangleSet;
                Shape renderShape = new Shape(triangleSet.getOrder(), triangleSet.getVertices(), triangleSet.getNormals(), triangleSet.getTexture());
                shapes.add(renderShape);
                X3dXML.Appearance appearance = shape.appearance;
                Material material = this.getMaterial(appearance);
                if (material == null) continue;
                renderShape.setMaterial(material);
            }
            X3dObject o = new X3dObject(name);
            o.shapes = shapes;
            o.rotations.set(rotations.x, rotations.y, rotations.z, rotations.w);
            o.offset.set(translation);
            o.scale = scale;
            this.parts.put(name, o);
            childMap.put(name, children);
        }
        for (Map.Entry entry : childMap.entrySet()) {
            String key = (String)entry.getKey();
            if (this.parts.get(key) == null) continue;
            IExtendedModelPart part = this.parts.get(key);
            for (String s : (Set)entry.getValue()) {
                if (this.parts.get(s) == null || this.parts.get(s) == part) continue;
                part.addChild(this.parts.get(s));
            }
        }
        return this.parts;
    }

    @Override
    public void preProcessAnimations(Collection<List<Animation>> animations) {
        for (List<Animation> list : animations) {
            for (Animation animation : list) {
                for (String s : animation.sets.keySet()) {
                    ArrayList<AnimationComponent> components = animation.sets.get(s);
                    for (AnimationComponent comp : components) {
                        comp.posOffset[0] = comp.posOffset[0] / -16.0;
                        comp.posOffset[1] = comp.posOffset[1] / -16.0;
                        comp.posOffset[2] = comp.posOffset[2] / -16.0;
                        comp.posChange[0] = comp.posChange[0] / -16.0;
                        comp.posChange[1] = comp.posChange[1] / -16.0;
                        comp.posChange[2] = comp.posChange[2] / -16.0;
                    }
                }
            }
        }
    }

    @Override
    public void renderAll() {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderAll();
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderAllExcept(excludedGroupNames);
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderOnly(groupNames);
        }
    }

    @Override
    public void renderPart(String partName) {
        for (IExtendedModelPart o : this.parts.values()) {
            if (o.getParent() != null) continue;
            o.renderPart(partName);
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        for (IExtendedModelPart part : this.parts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }

    @Override
    public Set<String> getHeadParts() {
        return this.heads;
    }

    @Override
    public IModel.HeadInfo getHeadInfo() {
        return this.info;
    }

    private void updateSubParts(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTick, IExtendedModelPart parent, float headYaw, float headPitch, float limbSwing) {
        if (parent == null) {
            return;
        }
        IModel.HeadInfo info = this.getHeadInfo();
        parent.resetToInit();
        boolean anim = renderer.getAnimations().containsKey(currentPhase);
        if (!anim || AnimationHelper.doAnimation(renderer.getAnimations().get(currentPhase), entity, parent.getName(), parent, partialTick, limbSwing)) {
            // empty if block
        }
        if (info != null && this.isHead(parent.getName())) {
            float ang2 = -info.headPitch;
            float head = info.headYaw + 180.0f;
            float diff = 0.0f;
            if (info.yawDirection != -1) {
                head *= -1.0f;
            }
            diff = head % 360.0f;
            diff = (diff + 360.0f) % 360.0f;
            diff = (diff - 180.0f) % 360.0f;
            diff = Math.max(diff, info.yawCapMin);
            float ang = diff = Math.min(diff, info.yawCapMax);
            ang2 = Math.max(ang2, info.pitchCapMin);
            ang2 = Math.min(ang2, info.pitchCapMax);
            Vector4 dir = info.yawAxis == 0 ? new Vector4(info.yawDirection, 0.0, 0.0, ang) : (info.yawAxis == 2 ? new Vector4(0.0, 0.0, info.yawDirection, ang) : new Vector4(0.0, info.yawDirection, 0.0, ang));
            Vector4 dir2 = info.pitchAxis == 2 ? new Vector4(0.0, 0.0, info.yawDirection, ang2) : (info.pitchAxis == 1 ? new Vector4(0.0, info.yawDirection, 0.0, ang2) : new Vector4(info.yawDirection, 0.0, 0.0, ang2));
            parent.setPostRotations(dir);
            parent.setPostRotations2(dir2);
        }
        int red = 255;
        int green = 255;
        int blue = 255;
        int brightness = entity.func_70070_b();
        int alpha = 255;
        if (entity instanceof IMobColourable) {
            IMobColourable poke = (IMobColourable)entity;
            red = poke.getRGBA()[0];
            green = poke.getRGBA()[1];
            blue = poke.getRGBA()[2];
            alpha = poke.getRGBA()[3];
        }
        int[] rgbab = parent.getRGBAB();
        IAnimationChanger animChanger = renderer.getAnimationChanger();
        if (animChanger != null) {
            int default_ = new Color(rgbab[0], rgbab[1], rgbab[2], rgbab[3]).getRGB();
            int rgb = animChanger.getColourForPart(parent.getName(), entity, default_);
            if (rgb != default_) {
                Color col = new Color(rgb);
                rgbab[0] = col.getRed();
                rgbab[1] = col.getGreen();
                rgbab[2] = col.getBlue();
                rgbab[4] = brightness;
            }
        } else {
            rgbab[0] = red;
            rgbab[1] = green;
            rgbab[2] = blue;
            rgbab[3] = alpha;
            rgbab[4] = brightness;
        }
        parent.setRGBAB(rgbab);
        for (String partName : parent.getSubParts().keySet()) {
            IExtendedModelPart part = parent.getSubParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTick, part, headYaw, headPitch, limbSwing);
        }
    }

    protected void updateAnimation(Entity entity, IModelRenderer<?> renderer, String currentPhase, float partialTicks, float headYaw, float headPitch, float limbSwing) {
        for (String partName : this.getParts().keySet()) {
            IExtendedModelPart part = this.getParts().get(partName);
            this.updateSubParts(entity, renderer, currentPhase, partialTicks, part, headYaw, headPitch, limbSwing);
        }
    }

    private boolean isHead(String partName) {
        return this.getHeadParts().contains(partName);
    }

    @Override
    public void applyAnimation(Entity entity, CapabilityAnimation.IAnimationHolder animate, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        this.updateAnimation(entity, renderer, renderer.getAnimation(entity), partialTicks, this.getHeadInfo().headYaw, this.getHeadInfo().headYaw, limbSwing);
    }
}

