/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.wrappers;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.animation.ModelHolder;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.IRetexturableModel;
import thut.core.client.render.tabula.components.Animation;

public class ModelWrapper
extends ModelBase
implements IModel {
    public final ModelHolder model;
    public final IModelRenderer<?> renderer;
    public IModel imodel;
    protected float rotationPointX = 0.0f;
    protected float rotationPointY = 0.0f;
    protected float rotationPointZ = 0.0f;
    protected float rotateAngleX = 0.0f;
    protected float rotateAngleY = 0.0f;
    protected float rotateAngleZ = 0.0f;
    protected float rotateAngle = 0.0f;
    private final IModelRenderer.Vector5 rots = new IModelRenderer.Vector5();

    public ModelWrapper(ModelHolder model, IModelRenderer<?> renderer) {
        this.model = model;
        this.renderer = renderer;
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        IModel.HeadInfo info = this.imodel.getHeadInfo();
        if (info != null) {
            info.currentTick = entityIn.field_70173_aa;
        }
        IAnimationChanger animChanger = this.renderer.getAnimationChanger();
        HashSet excluded = Sets.newHashSet();
        if (animChanger != null) {
            for (String partName : this.imodel.getParts().keySet()) {
                if (!animChanger.isPartHidden(partName, entityIn, false)) continue;
                excluded.add(partName);
            }
        }
        for (String partName : this.imodel.getParts().keySet()) {
            int default_;
            int rgb;
            IExtendedModelPart part = this.imodel.getParts().get(partName);
            if (part == null) continue;
            int[] rgbab = part.getRGBAB();
            if (animChanger != null && (rgb = animChanger.getColourForPart(partName, entityIn, default_ = new Color(rgbab[0], rgbab[1], rgbab[2], rgbab[3]).getRGB())) != default_) {
                Color col = new Color(rgb);
                rgbab[0] = col.getRed();
                rgbab[1] = col.getGreen();
                rgbab[2] = col.getBlue();
            }
            part.setRGBAB(rgbab);
            try {
                if (this.renderer.getTexturer() != null) {
                    this.renderer.getTexturer().bindObject(entityIn);
                }
                if (part instanceof IRetexturableModel) {
                    ((IRetexturableModel)((Object)part)).setTexturer(this.renderer.getTexturer());
                }
                if (part.getParent() != null) continue;
                GlStateManager.func_179094_E();
                part.renderAllExcept(this.renderer, excluded.toArray(new String[excluded.size()]));
                GlStateManager.func_179121_F();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (info != null) {
            info.lastTick = entityIn.field_70173_aa;
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        IModel.HeadInfo info = this.imodel.getHeadInfo();
        if (info != null) {
            info.headPitch = headPitch;
            info.headYaw = netHeadYaw;
        }
        this.transformGlobal(this.renderer.getAnimation(entityIn), entityIn, Minecraft.func_71410_x().func_184121_ak(), netHeadYaw, headPitch);
    }

    public void func_78086_a(EntityLivingBase entityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (this.renderer.getAnimationChanger() != null) {
            this.renderer.setAnimation(this.renderer.getAnimationChanger().modifyAnimation((EntityLiving)entityIn, partialTickTime, this.renderer.getAnimation((Entity)entityIn)), (Entity)entityIn);
        }
        this.applyAnimation((Entity)entityIn, (CapabilityAnimation.IAnimationHolder)entityIn.getCapability(CapabilityAnimation.CAPABILITY, null), this.renderer, partialTickTime, limbSwing);
    }

    @Override
    public HashMap<String, IExtendedModelPart> getParts() {
        return this.imodel.getParts();
    }

    @Override
    public void preProcessAnimations(Collection<List<Animation>> collection) {
        this.imodel.preProcessAnimations(collection);
    }

    protected void transformGlobal(String currentPhase, Entity entity, float partialTick, float rotationYaw, float rotationPitch) {
        IModelRenderer.Vector5 rotations = this.renderer.getRotations();
        if (rotations == null) {
            rotations = this.rots;
        }
        this.setRotationAngles(rotations.rotations);
        this.setOffset(this.renderer.getRotationOffset());
        float dy = this.rotationPointY - 1.5f;
        this.rotate();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)dy);
        this.translate();
        this.renderer.scaleEntity(entity, this, partialTick);
    }

    protected void rotate() {
        GlStateManager.func_179114_b((float)this.rotateAngle, (float)this.rotateAngleX, (float)this.rotateAngleY, (float)this.rotateAngleZ);
    }

    private void translate() {
        GlStateManager.func_179109_b((float)this.rotationPointX, (float)this.rotationPointY, (float)this.rotationPointZ);
    }

    public void setRotationAngles(Vector4 rotations) {
        this.rotateAngle = rotations.w;
        this.rotateAngleX = rotations.x;
        this.rotateAngleY = rotations.y;
        this.rotateAngleZ = rotations.z;
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    @Override
    public void setOffset(Vector3 point) {
        this.setRotationPoint((float)point.x, (float)point.y, (float)point.z);
    }

    @Override
    public Set<String> getHeadParts() {
        return this.imodel.getHeadParts();
    }

    @Override
    public IModel.HeadInfo getHeadInfo() {
        return this.imodel.getHeadInfo();
    }

    @Override
    public void applyAnimation(Entity entity, CapabilityAnimation.IAnimationHolder animate, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        this.imodel.applyAnimation(entity, animate, renderer, partialTicks, limbSwing);
    }
}

