/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class AnimationHelper {
    public static boolean doAnimation(List<Animation> list, Entity entity, String partName, IExtendedModelPart part, float partialTick, float limbSwing) {
        boolean animate = false;
        CapabilityAnimation.IAnimationHolder holder = (CapabilityAnimation.IAnimationHolder)entity.getCapability(CapabilityAnimation.CAPABILITY, null);
        if (holder != null) {
            for (Animation animation : list) {
                animate = AnimationHelper.animate(animation, holder, partName, part, partialTick, limbSwing, entity.field_70173_aa) || animate;
            }
        }
        return animate;
    }

    public static boolean animate(Animation animation, CapabilityAnimation.IAnimationHolder animate, String partName, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
        ArrayList<AnimationComponent> components = animation.getComponents(partName);
        boolean animated = false;
        Vector3 temp = Vector3.getNewVector();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        float sz = 1.0f;
        int aniTick = animate.getStep(animation);
        if (aniTick == 0) {
            aniTick = tick;
        }
        float time1 = aniTick;
        float time2 = 0.0f;
        int animationLength = animation.getLength();
        float limbSpeedFactor = 1.0f;
        time1 = (time1 + partialTick) % (float)animationLength;
        time2 = limbSwing * limbSpeedFactor % (float)animationLength;
        animate.setStep(animation, tick);
        if (components != null) {
            for (AnimationComponent component : components) {
                float f = component.limbBased ? time2 : time1;
                float time = f;
                if (!(time >= (float)component.startKey)) continue;
                animated = true;
                float componentTimer = time - (float)component.startKey;
                if (componentTimer > (float)component.length) {
                    componentTimer = component.length;
                }
                temp.addTo(component.posChange[0] / (double)component.length * (double)componentTimer + component.posOffset[0], component.posChange[1] / (double)component.length * (double)componentTimer + component.posOffset[1], component.posChange[2] / (double)component.length * (double)componentTimer + component.posOffset[2]);
                x += (float)(component.rotChange[0] / (double)component.length * (double)componentTimer + component.rotOffset[0]);
                y += (float)(component.rotChange[1] / (double)component.length * (double)componentTimer + component.rotOffset[1]);
                z += (float)(component.rotChange[2] / (double)component.length * (double)componentTimer + component.rotOffset[2]);
                sx += (float)(component.scaleChange[0] / (double)component.length * (double)componentTimer + component.scaleOffset[0]);
                sy += (float)(component.scaleChange[1] / (double)component.length * (double)componentTimer + component.scaleOffset[1]);
                sz += (float)(component.scaleChange[2] / (double)component.length * (double)componentTimer + component.scaleOffset[2]);
            }
        }
        if (animated) {
            part.setPreTranslations(temp);
            part.setPreScale(temp.set(sx, sy, sz));
            Vector4 angle = null;
            if (z != 0.0f) {
                angle = new Vector4(0.0, 0.0, 1.0, z);
            }
            if (y != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(0.0, 1.0, 0.0, y)) : new Vector4(0.0, 1.0, 0.0, y);
            }
            if (x != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(1.0, 0.0, 0.0, x)) : new Vector4(1.0, 0.0, 0.0, x);
            }
            if (angle != null) {
                part.setPreRotations(angle);
            }
        }
        return animated;
    }
}

