/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.ITerrainProvider;
import thut.api.terrain.TerrainSegment;

public class TerrainManager {
    public static final String TERRAIN = "pokecubeTerrainData";
    public static final ResourceLocation TERRAINCAP = new ResourceLocation("thutcore", "terrain");
    public ITerrainProvider provider = new ITerrainProvider(){};
    private static TerrainManager terrain;

    public static void clear() {
    }

    public static TerrainManager getInstance() {
        if (terrain == null) {
            terrain = new TerrainManager();
        }
        return terrain;
    }

    private TerrainManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        CapabilityManager.INSTANCE.register(CapabilityTerrain.ITerrainProvider.class, (Capability.IStorage)new CapabilityTerrain.Storage(), CapabilityTerrain.DefaultProvider::new);
    }

    @SubscribeEvent
    public void onCapabilityAttach(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getCapabilities().containsKey(TERRAINCAP)) {
            return;
        }
        Chunk chunk = (Chunk)event.getObject();
        CapabilityTerrain.DefaultProvider terrain = new CapabilityTerrain.DefaultProvider(chunk);
        event.addCapability(TERRAINCAP, (ICapabilityProvider)terrain);
    }

    @SubscribeEvent
    public void ChunkWatchEvent(ChunkWatchEvent.Watch evt) {
        if (evt.getPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        PacketHandler.sendTerrainToClient(evt.getPlayer().func_130014_f_(), evt.getChunk(), evt.getPlayer());
    }

    public TerrainSegment getTerrain(World world, BlockPos p) {
        return this.provider.getTerrain(world, p);
    }

    public TerrainSegment getTerrain(World world, double x, double y, double z) {
        BlockPos pos = new BlockPos(x, y, z);
        TerrainSegment ret = this.getTerrain(world, pos);
        if (!world.field_72995_K) {
            ret.initBiomes(world);
        }
        return ret;
    }

    public TerrainSegment getTerrainForEntity(Entity e) {
        if (e == null) {
            return null;
        }
        return this.getTerrain(e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public TerrainSegment getTerrian(World world, Vector3 v) {
        return this.getTerrain(world, v.x, v.y, v.z);
    }
}

