/*
 * Decompiled with CFR 0.152.
 */
package thut.api.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import thut.api.maths.Cruncher;
import thut.api.maths.Vector3;
import thut.api.network.IPlayerProvider;
import thut.api.terrain.BiomeType;
import thut.api.terrain.CapabilityTerrain;

public class PacketHandler {
    public static SimpleNetworkWrapper packetPipeline = NetworkRegistry.INSTANCE.newSimpleChannel("thut.api");
    public static IPlayerProvider provider;
    private static int id;

    public static void sendTerrainToClient(World world, ChunkPos pos, EntityPlayerMP player) {
        CapabilityTerrain.ITerrainProvider provider = (CapabilityTerrain.ITerrainProvider)world.func_72964_e(pos.field_77276_a, pos.field_77275_b).getCapability(CapabilityTerrain.TERRAIN_CAP, null);
        NBTTagCompound terrainData = (NBTTagCompound)CapabilityTerrain.TERRAIN_CAP.writeNBT((Object)provider, null);
        terrainData.func_74768_a("c_x", pos.field_77276_a);
        terrainData.func_74768_a("c_z", pos.field_77275_b);
        MessageClient message = new MessageClient(6, terrainData);
        packetPipeline.sendTo((IMessage)message, player);
    }

    public static int getMessageID() {
        return id++;
    }

    public static MessageClient makeClientPacket(byte channel, byte[] data) {
        byte[] packetData = new byte[data.length + 1];
        packetData[0] = channel;
        for (int i = 1; i < packetData.length; ++i) {
            packetData[i] = data[i - 1];
        }
        return new MessageClient(packetData);
    }

    public static MessageServer makeServerPacket(byte channel, byte[] data) {
        byte[] packetData = new byte[data.length + 1];
        packetData[0] = channel;
        for (int i = 1; i < packetData.length; ++i) {
            packetData[i] = data[i - 1];
        }
        return new MessageServer(packetData);
    }

    public static void sendEntityUpdate(Entity e) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        NBTTagCompound nbt = new NBTTagCompound();
        e.func_189511_e(nbt);
        buffer.writeByte(5);
        buffer.writeInt(e.func_145782_y());
        buffer.func_150786_a(nbt);
        MessageClient message = new MessageClient(buffer);
        PacketHandler.sendToAllNear(message, Vector3.getNewVector().set(e), e.func_130014_f_().field_73011_w.getDimension(), 64.0);
    }

    public static void sendTileUpdate(TileEntity tile) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        NBTTagCompound nbt = new NBTTagCompound();
        tile.func_189515_b(nbt);
        buffer.writeByte(3);
        buffer.func_150786_a(nbt);
        MessageClient message = new MessageClient(buffer);
        PacketHandler.sendToAllNear(message, Vector3.getNewVector().set(tile), tile.func_145831_w().field_73011_w.getDimension(), 64.0);
    }

    public static void sendTerrainValues(EntityPlayerMP player) {
        Map<Integer, String> values = BiomeType.getMap();
        NBTTagCompound tag = new NBTTagCompound();
        for (Integer i : values.keySet()) {
            tag.func_74768_a(values.get(i), i.intValue());
        }
        MessageClient message = new MessageClient(4, tag);
        packetPipeline.sendTo((IMessage)message, player);
    }

    public static void resendTerrainValues() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            PacketHandler.sendTerrainValues(player);
        }
    }

    public static void sendToAllNear(IMessage toSend, Vector3 point, int dimID, double distance) {
        packetPipeline.sendToAllAround(toSend, new NetworkRegistry.TargetPoint(dimID, point.x, point.y, point.z, distance));
    }

    static {
        id = 1;
        packetPipeline.registerMessage(MessageClient.MessageHandlerClient.class, MessageClient.class, PacketHandler.getMessageID(), Side.CLIENT);
        packetPipeline.registerMessage(MessageServer.MessageHandlerServer.class, MessageServer.class, PacketHandler.getMessageID(), Side.SERVER);
    }

    public static class ParticleTicker {
        public final int dimension;
        public final List<Integer> locs;
        public final int[] mid;

        public ParticleTicker(int dimension, List<Integer> locs, int[] mid) {
            this.dimension = dimension;
            this.locs = locs;
            this.mid = mid;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }

        @SubscribeEvent
        public void tick(TickEvent.ClientTickEvent evt) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            Vector3 vTemp = Vector3.getNewVector();
            Collections.shuffle(this.locs);
            int max = 50;
            Vector3 vMid = Vector3.getNewVector().set((Object)this.mid);
            vMid.addTo(0.5, 0.5, 0.5);
            int[] toFill = new int[3];
            int n = 0;
            for (Integer i : this.locs) {
                ++n;
                Cruncher.fillFromInt(toFill, i);
                vTemp.set((Object)toFill);
                vTemp.addTo(vMid);
                if (provider.getPlayer() == null || provider.getPlayer().func_130014_f_() == null) {
                    return;
                }
                provider.getPlayer().func_130014_f_().func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, vTemp.x, vTemp.y, vTemp.z, 0.0, 0.0, 0.0, new int[0]);
                if (n <= max) continue;
                break;
            }
        }
    }

    public static class MessageServer
    implements IMessage {
        PacketBuffer buffer;

        public MessageServer() {
        }

        public MessageServer(byte channel, NBTTagCompound nbt) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
            this.buffer.writeByte((int)channel);
            this.buffer.func_150786_a(nbt);
        }

        public MessageServer(byte[] data) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
            this.buffer.writeBytes(data);
        }

        public MessageServer(PacketBuffer buffer) {
            this.buffer = buffer;
        }

        public void fromBytes(ByteBuf buf) {
            if (this.buffer == null) {
                this.buffer = new PacketBuffer(Unpooled.buffer());
            }
            this.buffer.writeBytes(buf);
        }

        public void toBytes(ByteBuf buf) {
            if (this.buffer == null) {
                this.buffer = new PacketBuffer(Unpooled.buffer());
            }
            buf.writeBytes((ByteBuf)this.buffer);
        }

        public static class MessageHandlerServer
        implements IMessageHandler<MessageServer, IMessage> {
            public void handleServerSide(EntityPlayer player, PacketBuffer buffer) {
            }

            public IMessage onMessage(MessageServer message, MessageContext ctx) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                this.handleServerSide((EntityPlayer)player, message.buffer);
                return null;
            }
        }
    }

    public static class MessageClient
    implements IMessage {
        public static final byte BLASTAFFECTED = 1;
        public static final byte TELEPORTID = 2;
        public static final byte TILEUPDATE = 3;
        public static final byte TERRAINVALUES = 4;
        public static final byte ENTITYUPDATE = 5;
        public static final byte TERRAINSYNC = 6;
        PacketBuffer buffer;

        public MessageClient() {
        }

        public MessageClient(byte channel, NBTTagCompound nbt) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
            this.buffer.writeByte((int)channel);
            this.buffer.func_150786_a(nbt);
        }

        public MessageClient(byte[] data) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
            this.buffer.writeBytes(data);
        }

        public MessageClient(PacketBuffer buffer) {
            this.buffer = buffer;
        }

        public void fromBytes(ByteBuf buf) {
            if (this.buffer == null) {
                this.buffer = new PacketBuffer(Unpooled.buffer());
            }
            this.buffer.writeBytes(buf);
        }

        public void toBytes(ByteBuf buf) {
            if (this.buffer == null) {
                this.buffer = new PacketBuffer(Unpooled.buffer());
            }
            buf.writeBytes((ByteBuf)this.buffer);
        }

        public static class MessageHandlerClient
        implements IMessageHandler<MessageClient, MessageServer> {
            public void handleClientSide(EntityPlayer player, PacketBuffer buffer) {
                byte channel = buffer.readByte();
                if (player == null) {
                    return;
                }
                if (channel == 1) {
                    try {
                        NBTTagCompound nbt = buffer.func_150793_b();
                        int[] mid = nbt.func_74759_k("mid");
                        int[] affected = nbt.func_74759_k("affected");
                        ArrayList locs = Lists.newArrayList();
                        for (int i : affected) {
                            locs.add(i);
                        }
                        new ParticleTicker(player.field_71093_bK, locs, mid);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (channel == 2) {
                    int id = buffer.readInt();
                    if (player.func_130014_f_().func_73045_a(id) != null) {
                        player.func_130014_f_().func_73045_a(id).func_70106_y();
                    }
                    return;
                }
                if (channel == 3) {
                    try {
                        NBTTagCompound nbt = buffer.func_150793_b();
                        BlockPos pos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
                        TileEntity tile = player.func_130014_f_().func_175625_s(pos);
                        if (tile != null) {
                            tile.func_145839_a(nbt);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (channel == 4) {
                    try {
                        NBTTagCompound nbt = buffer.func_150793_b();
                        HashMap map = Maps.newHashMap();
                        for (String s : nbt.func_150296_c()) {
                            map.put(nbt.func_74762_e(s), s);
                        }
                        BiomeType.setMap(map);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (channel == 5) {
                    try {
                        int id = buffer.readInt();
                        NBTTagCompound nbt = buffer.func_150793_b();
                        Entity e = player.func_130014_f_().func_73045_a(id);
                        if (e != null) {
                            e.func_70020_e(nbt);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (channel == 6) {
                    try {
                        NBTTagCompound nbt = buffer.func_150793_b();
                        Chunk chunk = player.func_130014_f_().func_72964_e(nbt.func_74762_e("c_x"), nbt.func_74762_e("c_z"));
                        CapabilityTerrain.ITerrainProvider terrain = (CapabilityTerrain.ITerrainProvider)chunk.getCapability(CapabilityTerrain.TERRAIN_CAP, null);
                        CapabilityTerrain.TERRAIN_CAP.readNBT((Object)terrain, null, (NBTBase)nbt);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }

            public MessageServer onMessage(final MessageClient message, MessageContext ctx) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        this.handleClientSide(provider.getPlayer(), message.buffer);
                    }
                });
                return null;
            }
        }
    }
}

