/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.genetics;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import thut.api.entity.genetics.Gene;

public class GeneRegistry {
    static Map<ResourceLocation, Class<? extends Gene>> geneMap = Maps.newHashMap();

    public static Class<? extends Gene> getClass(ResourceLocation location) {
        return geneMap.get(location);
    }

    public static Collection<Class<? extends Gene>> getGenes() {
        return geneMap.values();
    }

    public static void register(Class<? extends Gene> gene) {
        try {
            Gene temp = gene.newInstance();
            geneMap.put(temp.getKey(), gene);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound save(Gene gene) {
        NBTTagCompound tag = gene.save();
        tag.func_74778_a("K", gene.getKey().toString());
        return tag;
    }

    public static Gene load(NBTTagCompound tag) throws Exception {
        Gene ret = null;
        ResourceLocation resource = new ResourceLocation(tag.func_74779_i("K"));
        ret = geneMap.get(resource).newInstance();
        ret.load(tag);
        return ret;
    }
}

