/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thut.api.entity.blockentity.IBlockEntity;
import thut.lib.CompatWrapper;

public class BlockEntityInteractHandler {
    final IBlockEntity blockEntity;
    final Entity theEntity;

    public BlockEntityInteractHandler(IBlockEntity entity) {
        this.blockEntity = entity;
        this.theEntity = (Entity)entity;
    }

    public EnumActionResult applyPlayerInteraction(EntityPlayer player, Vec3d vec, @Nullable ItemStack stack, EnumHand hand) {
        float hitX;
        float hitY;
        float hitZ;
        BlockPos pos;
        Vec3d playerPos;
        vec = vec.func_72441_c(vec.field_72450_a > 0.0 ? -0.01 : 0.01, vec.field_72448_b > 0.0 ? -0.01 : 0.01, vec.field_72449_c > 0.0 ? -0.01 : 0.01);
        Vec3d start = playerPos = player.func_174791_d().func_72441_c(0.0, player.func_70613_aW() ? (double)player.func_70047_e() : 0.0, 0.0);
        Vec3d end = playerPos.func_178787_e(player.func_70040_Z().func_186678_a(4.5));
        RayTraceResult trace = IBlockEntity.BlockEntityFormer.rayTraceInternal(start, end, this.blockEntity);
        EnumFacing side = EnumFacing.DOWN;
        if (trace == null) {
            pos = new BlockPos(0, 0, 0);
            hitZ = 0.0f;
            hitY = 0.0f;
            hitX = 0.0f;
        } else {
            pos = trace.func_178782_a();
            hitX = (float)(trace.field_72307_f.field_72450_a - (double)pos.func_177958_n());
            hitY = (float)(trace.field_72307_f.field_72448_b - (double)pos.func_177956_o());
            hitZ = (float)(trace.field_72307_f.field_72449_c - (double)pos.func_177952_p());
            side = trace.field_178784_b;
        }
        IBlockState state = this.blockEntity.getFakeWorld().func_180495_p(pos);
        boolean activate = CompatWrapper.interactWithBlock(state.func_177230_c(), this.blockEntity.getFakeWorld(), pos, state, player, hand, stack, side, hitX, hitY, hitZ);
        if (activate) {
            return EnumActionResult.SUCCESS;
        }
        if (trace == null || !state.func_185904_a().func_76220_a()) {
            Vec3d playerLook = playerPos.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
            RayTraceResult result = this.theEntity.func_130014_f_().func_147447_a(playerPos, playerLook, false, true, false);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                EnumActionResult itemUse;
                pos = result.func_178782_a();
                state = this.theEntity.func_130014_f_().func_180495_p(pos);
                hitX = (float)(result.field_72307_f.field_72450_a - (double)pos.func_177958_n());
                hitY = (float)(result.field_72307_f.field_72448_b - (double)pos.func_177956_o());
                hitZ = (float)(result.field_72307_f.field_72449_c - (double)pos.func_177952_p());
                if (player.func_70093_af() && !stack.func_190926_b() && (itemUse = ForgeHooks.onPlaceItemIntoWorld((ItemStack)stack, (EntityPlayer)player, (World)player.func_130014_f_(), (BlockPos)pos, (EnumFacing)result.field_178784_b, (float)hitX, (float)hitY, (float)hitZ, (EnumHand)hand)) != EnumActionResult.PASS) {
                    return itemUse;
                }
                activate = CompatWrapper.interactWithBlock(state.func_177230_c(), this.theEntity.func_130014_f_(), pos, state, player, hand, stack, result.field_178784_b, hitX, hitY, hitZ);
                if (activate) {
                    return EnumActionResult.SUCCESS;
                }
                if (!player.func_70093_af() && !stack.func_190926_b() && (itemUse = ForgeHooks.onPlaceItemIntoWorld((ItemStack)stack, (EntityPlayer)player, (World)player.func_130014_f_(), (BlockPos)pos, (EnumFacing)result.field_178784_b, (float)hitX, (float)hitY, (float)hitZ, (EnumHand)hand)) != EnumActionResult.PASS) {
                    return itemUse;
                }
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public boolean processInitialInteract(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        return false;
    }
}

