/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.WorldCache;
import thut.api.block.IOwnableTE;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.core.common.ThutCore;

public class TickHandler {
    private static TickHandler instance;
    public static int maxChanges;
    static Map<Thread, ArrayList<BlockChange>> lists;
    public HashMap<Integer, Vector<BlockChange>> blocks = new HashMap();
    public HashMap<Integer, IBlockAccess> worldCaches = new HashMap();
    HashMap<Integer, HashSet<Long>> toRefresh = new HashMap();
    public static Map<UUID, Integer> playerTickTracker;

    public static void addBlockChange(BlockChange b1, int dimension) {
        if (b1.location.y > 255.0) {
            return;
        }
        TickHandler.getInstance();
        ArrayList<BlockChange> blocks = TickHandler.getList();
        blocks.addAll(TickHandler.getListForDimension(dimension));
        for (BlockChange b : blocks) {
            if (!b.equals(b1)) continue;
            return;
        }
        TickHandler.getInstance();
        TickHandler.getListForDimension(dimension).add(b1);
    }

    public static void addBlockChange(Vector3 location, int dimension, Block blockTo) {
        TickHandler.addBlockChange(location, dimension, blockTo, 0);
    }

    public static void addBlockChange(Vector3 location, int dimension, Block blockTo, int meta) {
        TickHandler.addBlockChange(new BlockChange(location, dimension, blockTo, meta), dimension);
    }

    public static void cleanup() {
        Thread thread = Thread.currentThread();
        lists.remove(thread);
        System.gc();
    }

    public static TickHandler getInstance() {
        if (instance == null) {
            new TickHandler();
        }
        return instance;
    }

    private static ArrayList<BlockChange> getList() {
        Thread thread = Thread.currentThread();
        if (lists.containsKey(thread)) {
            ArrayList<BlockChange> ret = lists.get(thread);
            ret.clear();
            return ret;
        }
        ArrayList ret = Lists.newArrayList();
        lists.put(thread, ret);
        return ret;
    }

    public static Vector<BlockChange> getListForDimension(int dim) {
        Vector<BlockChange> ret = TickHandler.getInstance().blocks.get(dim);
        if (ret == null) {
            ret = new Vector();
            TickHandler.getInstance().blocks.put(dim, ret);
        }
        return ret;
    }

    public static Vector<BlockChange> getListForWorld(World world) {
        Vector<BlockChange> ret = TickHandler.getInstance().blocks.get(world.field_73011_w.getDimension());
        if (ret == null) {
            ret = new Vector();
            TickHandler.getInstance().blocks.put(world.field_73011_w.getDimension(), ret);
        }
        return ret;
    }

    public TickHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        new PacketHandler();
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void ChunkLoadEvent(ChunkEvent.Load evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        IBlockAccess world = this.getWorldCache(evt.getWorld().field_73011_w.getDimension());
        if (world == null) {
            world = ThutCore.instance.config.multithreadedAI ? new WorldCache(evt.getWorld()) : evt.getWorld();
            HashMap<Integer, IBlockAccess> hashMap = this.worldCaches;
            synchronized (hashMap) {
                this.worldCaches.put(evt.getWorld().field_73011_w.getDimension(), world);
            }
        }
        if (world instanceof WorldCache) {
            ((WorldCache)world).addChunk(evt.getChunk());
        }
    }

    @SubscribeEvent
    public void ChunkUnLoadEvent(ChunkEvent.Unload evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        IBlockAccess world = this.getWorldCache(evt.getWorld().field_73011_w.getDimension());
        if (world != null && world instanceof WorldCache) {
            ((WorldCache)world).removeChunk(evt.getChunk());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void PlayerTick(TickEvent.PlayerTickEvent event) {
        Integer time;
        if (event.phase == TickEvent.Phase.END && playerTickTracker.containsKey(event.player.func_110124_au()) && (time = playerTickTracker.get(event.player.func_110124_au())) < (int)(System.currentTimeMillis() % 2000L) - 100) {
            Minecraft.func_71410_x().field_71474_y.field_74336_f = true;
        }
        if (event.phase == TickEvent.Phase.END && event.side == Side.CLIENT && event.player.field_70173_aa == event.player.getEntityData().func_74762_e("lastStandTick") + 1) {
            event.player.field_70122_E = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlockAccess getWorldCache(int dimension) {
        HashMap<Integer, IBlockAccess> hashMap = this.worldCaches;
        synchronized (hashMap) {
            return this.worldCaches.get(dimension);
        }
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.PlaceEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te != null && te instanceof IOwnableTE) {
            IOwnableTE ownable = (IOwnableTE)te;
            ownable.setPlacer((Entity)event.getPlayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void WorldLoadEvent(WorldEvent.Load evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        HashMap<Integer, IBlockAccess> hashMap = this.worldCaches;
        synchronized (hashMap) {
            this.worldCaches.put(evt.getWorld().field_73011_w.getDimension(), new WorldCache(evt.getWorld()));
        }
    }

    @SubscribeEvent
    public void worldTickEvent(TickEvent.WorldTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || !this.blocks.containsKey(evt.world.field_73011_w.getDimension()) || this.blocks.get(evt.world.field_73011_w.getDimension()).size() == 0 || evt.world.field_72995_K) {
            return;
        }
        int num = 0;
        ArrayList removed = Lists.newArrayList();
        Vector<BlockChange> blocks = this.blocks.get(evt.world.field_73011_w.getDimension());
        ArrayList toRemove = Lists.newArrayList(blocks);
        for (int i = 0; i < toRemove.size(); ++i) {
            BlockChange b = (BlockChange)toRemove.get(i);
            b.changeBlock(evt.world);
            removed.add(b);
            if (++num >= maxChanges * 5) break;
        }
        for (BlockChange b : removed) {
            blocks.remove(b);
        }
        removed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload evt) {
        if (evt.getWorld().field_73011_w.getDimension() == 0) {
            this.blocks.clear();
        }
        HashMap<Integer, IBlockAccess> hashMap = this.worldCaches;
        synchronized (hashMap) {
            this.worldCaches.remove(evt.getWorld().field_73011_w.getDimension());
        }
    }

    static {
        maxChanges = 200;
        lists = Maps.newConcurrentMap();
        playerTickTracker = Maps.newHashMap();
    }

    public static class BlockChange {
        public int dimension;
        public Vector3 location;
        public Block blockTo;
        public Block blockFrom;
        public int metaTo = 0;
        public int flag = 3;

        public BlockChange(Vector3 location, int dim, Block blockTo) {
            this.dimension = dim;
            this.location = location.copy();
            this.blockTo = blockTo;
        }

        public BlockChange(Vector3 location, int dim, Block blockTo, int meta) {
            this.dimension = dim;
            this.location = location.copy();
            this.blockTo = blockTo;
            this.metaTo = meta;
        }

        public boolean changeBlock(World world) {
            boolean ret = this.location.setBlock(world, this.blockTo, this.metaTo, this.flag);
            return ret;
        }

        public boolean equals(Object o) {
            if (o instanceof BlockChange) {
                BlockChange b = (BlockChange)o;
                return this.dimension == b.dimension && this.location.sameBlock(b.location);
            }
            return false;
        }

        public String toString() {
            return this.blockTo + " " + this.dimension + " " + this.location;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

