/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryManager {
    public static final RegistryManager ACTIVE = new RegistryManager("ACTIVE");
    public static final RegistryManager VANILLA = new RegistryManager("VANILLA");
    public static final RegistryManager FROZEN = new RegistryManager("FROZEN");
    BiMap<nf, ForgeRegistry<? extends IForgeRegistryEntry<?>>> registries = HashBiMap.create();
    private BiMap<Class<? extends IForgeRegistryEntry<?>>, nf> superTypes = HashBiMap.create();
    private Set<nf> persisted = Sets.newHashSet();
    private final String name;

    public RegistryManager(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public <V extends IForgeRegistryEntry<V>> Class<V> getSuperType(nf key) {
        return (Class)this.superTypes.inverse().get((Object)key);
    }

    public <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> getRegistry(nf key) {
        return (ForgeRegistry)this.registries.get((Object)key);
    }

    public <V extends IForgeRegistryEntry<V>> IForgeRegistry<V> getRegistry(Class<V> cls) {
        return this.getRegistry((nf)this.superTypes.get(cls));
    }

    public <V extends IForgeRegistryEntry<V>> nf getName(IForgeRegistry<V> reg) {
        return (nf)this.registries.inverse().get(reg);
    }

    public <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> getRegistry(nf key, RegistryManager other) {
        if (!this.registries.containsKey((Object)key)) {
            ForgeRegistry<V> ot2 = other.getRegistry(key);
            if (ot2 == null) {
                return null;
            }
            this.registries.put((Object)key, ot2.copy(this));
            this.superTypes.put(ot2.getRegistrySuperType(), (Object)key);
            if (other.persisted.contains(key)) {
                this.persisted.add(key);
            }
        }
        return this.getRegistry(key);
    }

    <V extends IForgeRegistryEntry<V>> ForgeRegistry<V> createRegistry(nf name, Class<V> type, nf defaultKey, int min, int max, @Nullable IForgeRegistry.AddCallback<V> add, @Nullable IForgeRegistry.ClearCallback<V> clear, @Nullable IForgeRegistry.CreateCallback<V> create, boolean persisted, boolean allowOverrides, boolean isModifiable, @Nullable IForgeRegistry.DummyFactory<V> dummyFactory, @Nullable IForgeRegistry.MissingFactory<V> missing) {
        HashSet parents = Sets.newHashSet();
        this.findSuperTypes(type, parents);
        Sets.SetView overlappedTypes = Sets.intersection((Set)parents, (Set)this.superTypes.keySet());
        if (!overlappedTypes.isEmpty()) {
            Class foundType = (Class)overlappedTypes.iterator().next();
            FMLLog.log.error("Found existing registry of type {} named {}, you cannot create a new registry ({}) with type {}, as {} has a parent of that type", (Object)foundType, this.superTypes.get((Object)foundType), (Object)name, type, type);
            throw new IllegalArgumentException("Duplicate registry parent type found - you can only have one registry for a particular super type");
        }
        ForgeRegistry<V> reg = new ForgeRegistry<V>(type, defaultKey, min, max, create, add, clear, this, allowOverrides, isModifiable, dummyFactory, missing);
        this.registries.put((Object)name, reg);
        this.superTypes.put(type, (Object)name);
        if (persisted) {
            this.persisted.add(name);
        }
        return this.getRegistry(name);
    }

    private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
        if (type == null || type == Object.class) {
            return;
        }
        types.add(type);
        for (Class<?> interfac : type.getInterfaces()) {
            this.findSuperTypes(interfac, types);
        }
        this.findSuperTypes(type.getSuperclass(), types);
    }

    public Map<nf, ForgeRegistry.Snapshot> takeSnapshot(boolean savingToDisc) {
        HashMap ret = Maps.newHashMap();
        Set keys = savingToDisc ? this.persisted : this.registries.keySet();
        keys.forEach(name -> ret.put(name, this.getRegistry((nf)name).makeSnapshot()));
        return ret;
    }

    public void clean() {
        this.persisted.clear();
        this.registries.clear();
        this.superTypes.clear();
    }
}

