/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.util.Arrays;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ObfuscationReflectionHelper {
    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, int fieldIndex) {
        try {
            return ReflectionHelper.getPrivateValue(classToAccess, instance, fieldIndex);
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            FMLLog.log.error("There was a problem getting field index {} from {}", (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
    }

    public static String[] remapFieldNames(String className, String ... fieldNames) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String[] mappedNames = new String[fieldNames.length];
        int i2 = 0;
        for (String fName : fieldNames) {
            mappedNames[i2++] = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(internalClassName, fName, null);
        }
        return mappedNames;
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return ReflectionHelper.getPrivateValue(classToAccess, instance, ObfuscationReflectionHelper.remapFieldNames(classToAccess.getName(), fieldNames));
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            FMLLog.log.error("Unable to locate any field {} on type {}", (Object)Arrays.toString(fieldNames), (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            FMLLog.log.error("Unable to access any field {} on type {}", (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            ReflectionHelper.setPrivateValue(classToAccess, instance, value, fieldIndex);
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            FMLLog.log.error("There was a problem setting field index {} on type {}", (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            ReflectionHelper.setPrivateValue(classToAccess, instance, value, ObfuscationReflectionHelper.remapFieldNames(classToAccess.getName(), fieldNames));
        }
        catch (ReflectionHelper.UnableToFindFieldException e) {
            FMLLog.log.error("Unable to locate any field {} on type {}", (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            FMLLog.log.error("Unable to set any field {} on type {}", (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
    }
}

