/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.items;

import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.blocks.BlockStickyFrame;
import com.rwtema.funkylocomotion.movers.IMover;
import com.rwtema.funkylocomotion.movers.MoverEventHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrench
extends Item {
    public static final int metaWrenchNormal = 0;
    public static final int metaWrenchEye = 1;
    public static final int metaWrenchHammer = 2;
    static EnumFacing[] offsetDir1 = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.NORTH};
    static EnumFacing[] offsetDir2 = new EnumFacing[]{EnumFacing.WEST, EnumFacing.WEST, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP, EnumFacing.UP};

    public ItemWrench() {
        this.func_77625_d(1);
        this.setRegistryName("funkylocomotion:wrench");
        this.func_77655_b("funkylocomotion:wrench");
        this.func_77637_a(FunkyLocomotion.creativeTabFrames);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 1));
            list.add((Object)new ItemStack((Item)this, 1, 2));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, @Nonnull List<String> list, ITooltipFlag advanced) {
        if (stack.func_77952_i() == 1) {
            list.add(I18n.func_135052_a((String)"tooltip.funkylocomotion:wrench_eye", (Object[])new Object[0]));
        } else if (stack.func_77952_i() == 2) {
            list.add(I18n.func_135052_a((String)"tooltip.funkylocomotion:wrench_hammer", (Object[])new Object[0]));
        }
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() != 2) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            FunkyLocomotion.proxy.sendUsePacket(pos, side, hand, hitX, hitY, hitZ);
            return EnumActionResult.SUCCESS;
        }
        EnumFacing d1 = offsetDir1[side.ordinal()];
        EnumFacing d2 = offsetDir2[side.ordinal()];
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return EnumActionResult.PASS;
        }
        if (block instanceof BlockStickyFrame) {
            state = state.func_185899_b((IBlockAccess)world, pos);
            boolean isOpen = (Boolean)state.func_177229_b((IProperty)BlockStickyFrame.DIR_OPEN_MAP.get(side));
            for (BlockPos.MutableBlockPos otherPos : BlockPos.func_177975_b((BlockPos)pos.func_177967_a(d1, -2).func_177967_a(d2, -2), (BlockPos)pos.func_177967_a(d1, 2).func_177967_a(d2, 2))) {
                BlockPos blockingPos;
                if (otherPos.equals((Object)pos)) {
                    block.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
                    continue;
                }
                IBlockState otherBlockState = world.func_180495_p((BlockPos)otherPos);
                Block otherBlock = otherBlockState.func_177230_c();
                if (!(otherBlock instanceof BlockStickyFrame) || (Boolean)otherBlockState.func_177229_b((IProperty)BlockStickyFrame.DIR_OPEN_MAP.get(side)) != isOpen || this.isInaccessible(world, side, hitX, hitY, hitZ, blockingPos = otherPos.func_177972_a(side))) continue;
                otherBlock.func_180639_a(world, (BlockPos)otherPos, otherBlockState, player, hand, side, hitX, hitY, hitZ);
            }
        } else {
            for (BlockPos.MutableBlockPos otherPos : BlockPos.func_177975_b((BlockPos)pos.func_177967_a(d1, -1).func_177967_a(d2, -1), (BlockPos)pos.func_177972_a(d1).func_177972_a(d2))) {
                IBlockState otherBlockState = world.func_180495_p((BlockPos)otherPos);
                Block otherBlock = otherBlockState.func_177230_c();
                if (otherBlockState != state || otherBlock.isAir(otherBlockState, (IBlockAccess)world, (BlockPos)otherPos)) continue;
                BlockPos blockingPos = otherPos.func_177972_a(side.func_176734_d());
                if (!pos.equals((Object)otherPos) && this.isInaccessible(world, side, hitX, hitY, hitZ, blockingPos)) continue;
                otherBlock.func_180639_a(world, (BlockPos)otherPos, otherBlockState, player, hand, side, hitX, hitY, hitZ);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean isInaccessible(World world, EnumFacing side, float hitX, float hitY, float hitZ, BlockPos blockingPos) {
        IBlockState blockingState = world.func_180495_p(blockingPos);
        Block blockingBlock = blockingState.func_177230_c();
        if (!blockingBlock.isAir(blockingState, (IBlockAccess)world, blockingPos) && blockingState.func_185890_d((IBlockAccess)world, blockingPos) != null && blockingBlock.func_176209_a(blockingState, false)) {
            int face = side.ordinal();
            if (blockingState.func_185910_a(world, blockingPos, new Vec3d((double)blockingPos.func_177958_n() + (face == 4 ? -0.1 : (face == 5 ? 1.1 : (double)hitX)), (double)blockingPos.func_177956_o() + (face == 0 ? -0.1 : (face == 1 ? 1.1 : (double)hitY)), (double)blockingPos.func_177952_p() + (face == 2 ? -0.1 : (face == 3 ? 1.1 : (double)hitZ))), new Vec3d((double)blockingPos.func_177958_n() + (face == 4 ? 1.1 : (face == 5 ? -0.1 : (double)hitX)), (double)blockingPos.func_177956_o() + (face == 0 ? 1.1 : (face == 1 ? -0.1 : (double)hitY)), (double)blockingPos.func_177952_p() + (face == 2 ? 1.1 : (face == 3 ? -0.1 : (double)hitZ)))) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity;
        if (!player.func_130014_f_().field_72995_K && (tileEntity = player.func_130014_f_().func_175625_s(pos)) instanceof IMover) {
            MoverEventHandler.registerMover((IMover)tileEntity);
        }
        return true;
    }

    @Nonnull
    public String func_77667_c(ItemStack itemstack) {
        if (itemstack.func_77952_i() == 1) {
            return "item.funkylocomotion:wrench_eye";
        }
        if (itemstack.func_77952_i() == 2) {
            return "item.funkylocomotion:wrench_hammer";
        }
        return super.func_77667_c(itemstack);
    }

    @SubscribeEvent
    public void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        TileEntity tileEntity;
        ItemStack heldItem = event.getEntityPlayer().func_184586_b(event.getHand());
        if (heldItem.func_190926_b() || heldItem.func_77973_b() != this) {
            return;
        }
        if (!event.getWorld().field_72995_K && (tileEntity = event.getWorld().func_175625_s(event.getPos())) instanceof IMover) {
            MoverEventHandler.registerMover((IMover)tileEntity);
        }
        event.setCanceled(true);
    }
}

