/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.items;

import com.rwtema.funkylocomotion.rendering.WordDictionary;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTeleporter
extends ItemBlock {
    public static final String NBT_TELEPORTER_ID = "TeleportID";
    public static Random rand = new Random();

    public ItemBlockTeleporter(Block block) {
        super(block);
        this.func_77625_d(2);
    }

    public static ItemStack assignRandomID(ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(NBT_TELEPORTER_ID, Math.abs(rand.nextInt()) & 0xFFFFF);
        item.func_77982_d(tag);
        return item;
    }

    public static ItemStack assignNullID(ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(NBT_TELEPORTER_ID, 0);
        item.func_77982_d(tag);
        return item;
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int slot, boolean held) {
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b(NBT_TELEPORTER_ID) && tag.func_74762_e(NBT_TELEPORTER_ID) == 0) {
            tag.func_82580_o(NBT_TELEPORTER_ID);
            if (tag.func_82582_d()) {
                item.func_77982_d(null);
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer playerIn, World worldIn, @Nonnull BlockPos pos, EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || tag.func_74762_e(NBT_TELEPORTER_ID) == 0) {
            if (worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.teleport.no_id.0", new Object[0]));
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("frame.teleport.no_id.1", new Object[0]));
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack item, @Nullable World world, @Nonnull List<String> list, ITooltipFlag advanced) {
        super.func_77624_a(item, world, list, advanced);
        NBTTagCompound tagCompound = item.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b(NBT_TELEPORTER_ID)) {
            list.add(I18n.func_135052_a((String)"frame.teleport.no_id.0", (Object[])new Object[0]));
            list.add(I18n.func_135052_a((String)"frame.teleport.no_id.1", (Object[])new Object[0]));
            return;
        }
        int id = tagCompound.func_74762_e(NBT_TELEPORTER_ID);
        if (id == 0) {
            return;
        }
        if (id < 0) {
            id = -id;
        }
        id &= 0xFFFFF;
        StringBuilder builder = new StringBuilder().append(I18n.func_135052_a((String)"frame.teleport.id", (Object[])new Object[0])).append(": ").append('\"');
        String[] words = WordDictionary.getWords();
        while (id != 0) {
            builder.append(words[id % words.length]);
            id /= words.length;
        }
        builder.append('\"');
        list.add(builder.toString());
    }
}

