/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.energy.EnergyStorageSerializable;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TilePowered
extends TileEntity {
    public final EnergyStorageSerializable energy;
    private final IEnergyStorage public_energy_wrapper;

    public TilePowered(int capacity) {
        this.energy = this.createStorage(capacity);
        this.public_energy_wrapper = TilePusher.powerPerTile > 0 ? new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return TilePowered.this.energy.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return TilePowered.this.energy.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return TilePowered.this.energy.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        } : null;
    }

    @Nonnull
    protected EnergyStorageSerializable createStorage(int capacity) {
        return new EnergyStorageSerializable(capacity, capacity, capacity){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int i = super.receiveEnergy(maxReceive, simulate);
                if (!simulate && i != 0) {
                    TilePowered.this.func_70296_d();
                }
                return i;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int i = super.extractEnergy(maxExtract, simulate);
                if (!simulate && i != 0) {
                    TilePowered.this.func_70296_d();
                }
                return i;
            }
        };
    }

    @OverridingMethodsMustInvokeSuper
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        return tag;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && TilePusher.powerPerTile > 0 || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && TilePusher.powerPerTile > 0) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.public_energy_wrapper);
        }
        return (T)super.getCapability(capability, facing);
    }
}

