/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.FunkyLocomotion;
import com.rwtema.funkylocomotion.blocks.BlockFLMultiState;
import com.rwtema.funkylocomotion.blocks.TileFrameProjector;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.helper.ItemHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockFrameProjector
extends BlockFLMultiState {
    public BlockFrameProjector() {
        super(Material.field_151576_e);
        this.setRegistryName("funkylocomotion:frame_projector");
        this.func_149663_c("funkylocomotion:frame_projector");
        this.func_149647_a(FunkyLocomotion.creativeTabFrames);
        this.func_149711_c(1.0f);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.values()[meta % 6]);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileFrameProjector((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N));
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        EnumFacing facingFromEntity = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facingFromEntity);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileFrameProjector) {
            ((TileFrameProjector)tileEntity).range = 1;
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack item = playerIn.func_184586_b(hand);
            if (!ItemHelper.isWrench(item)) {
                return false;
            }
            if (playerIn.func_70093_af()) {
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileFrameProjector) {
                    TileFrameProjector projector = (TileFrameProjector)tileEntity;
                    ++projector.range;
                    if (projector.range > 16) {
                        projector.range = 1;
                    }
                    BlockHelper.markBlockForUpdate(worldIn, pos);
                    return true;
                }
            } else {
                IBlockState blockState = worldIn.func_180495_p(pos);
                EnumFacing face = (EnumFacing)blockState.func_177229_b((IProperty)BlockDirectional.field_176387_N);
                if (side == face) {
                    side = face.func_176734_d();
                }
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)side), 3);
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileFrameProjector) {
                    TileFrameProjector projector = (TileFrameProjector)tileEntity;
                    projector.facing = side;
                    BlockHelper.markBlockForUpdate(worldIn, pos);
                }
                return true;
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileFrameProjector)) {
            return;
        }
        TileFrameProjector tileFrameProjector = (TileFrameProjector)tile;
        if (!(world instanceof WorldServer)) {
            return;
        }
        boolean prevPowered = tileFrameProjector.powered;
        boolean bl = tileFrameProjector.powered = world.func_175687_A(pos) == 0;
        if (prevPowered != tileFrameProjector.powered) {
            BlockHelper.markBlockForUpdate(world, pos);
        }
    }
}

