/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.lib.util.StackHelper;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.init.ModItems;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartVanillaBasic implements IPartProperties
{
    WOOD("wood", EnumMaterialTier.MUNDANE, 8807718, 0, 69, 2.0f, 0.0f, 0.0f, 1.1f, 10, 15, 1.5f),
    OAK(WOOD, "oak", 12359778),
    BIRCH(WOOD, "birch", 14142349),
    SPRUCE(WOOD, "spruce", 8807718),
    JUNGLE(WOOD, "jungle", 12093284),
    DARK_OAK(WOOD, "dark_oak", 4599061),
    ACACIA(WOOD, "acacia", 12216379),
    STONE("stone", EnumMaterialTier.MUNDANE, 0x9A9A9A, 1, 144, 4.0f, 1.0f, 0.0f, 0.9f, 7, 5, 1.0f);

    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartVanillaBasic(EnumPartVanillaBasic mirror, String name, int color) {
        this.name = name;
        this.color = color;
        this.tier = mirror.tier;
        this.durability = mirror.durability;
        this.miningSpeed = mirror.miningSpeed;
        this.meleeDamage = mirror.meleeDamage;
        this.magicDamage = mirror.magicDamage;
        this.meleeSpeed = mirror.meleeSpeed;
        this.enchantability = mirror.enchantability;
        this.chargeSpeed = mirror.chargeSpeed;
        this.protection = mirror.protection;
        this.harvestLevel = mirror.harvestLevel;
    }

    private EnumPartVanillaBasic(String name, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", "polished.prefix", new Object[0]);
    }

    public ItemStack getCraftingStack() {
        switch (this) {
            case STONE: {
                return ModItems.generic.polishedStone;
            }
            case WOOD: {
                return ModItems.generic.polishedWood;
            }
            case ACACIA: {
                return ModItems.generic.polishedAcacia;
            }
            case BIRCH: {
                return ModItems.generic.polishedBirch;
            }
            case DARK_OAK: {
                return ModItems.generic.polishedDarkOak;
            }
            case JUNGLE: {
                return ModItems.generic.polishedJungle;
            }
            case OAK: {
                return ModItems.generic.polishedOak;
            }
            case SPRUCE: {
                return ModItems.generic.polishedSpruce;
            }
        }
        return StackHelper.empty();
    }

    public String getCraftingOreName() {
        return "";
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartVanillaBasic part : EnumPartVanillaBasic.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule("vanilla_basic", names.toArray(new String[names.size()]), (Object[])EnumPartVanillaBasic.values());
        for (EnumPartVanillaBasic part : EnumPartVanillaBasic.values()) {
            if (!enabled[part.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

