/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.init.ModItems;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartMetal implements IPartProperties
{
    COPPER("Copper", EnumMaterialTier.MUNDANE, 0xFF8000, 185, 4.0f, 1.0f, 1.5f, 1.2f, 10, 12, 2.0f),
    TIN("Tin", EnumMaterialTier.MUNDANE, 0xFFFFCC, 220, 3.5f, 1.0f, 1.0f, 1.0f, 14, 10, 1.0f),
    SILVER("Silver", EnumMaterialTier.REGULAR, 0xD4D4D4, 200, 6.0f, 1.5f, 3.0f, 1.1f, 14, 16, 3.0f),
    LEAD("Lead", EnumMaterialTier.REGULAR, 11834580, 150, 5.0f, 1.0f, 0.5f, 0.8f, 12, 8, 1.0f),
    NICKEL("Nickel", EnumMaterialTier.MUNDANE, 0xFFCC99, 300, 6.5f, 2.5f, 1.5f, 1.1f, 12, 13, 2.0f),
    PLATINUM("Platinum", EnumMaterialTier.SUPER, 0xB3B3FF, 900, 12.0f, 4.0f, 4.0f, 1.0f, 18, 14, 2.0f),
    ALUMINIUM("Aluminium", EnumMaterialTier.REGULAR, 0xFFFFFF, 300, 7.0f, 3.0f, 2.0f, 1.3f, 15, 10, 1.0f),
    ALUMINUM("Aluminum", EnumMaterialTier.REGULAR, 0xFFFFFF, 300, 7.0f, 3.0f, 2.0f, 1.3f, 15, 10, 1.0f),
    ZINC("Zinc", EnumMaterialTier.MUNDANE, 0xDDCCFF, 200, 3.0f, 1.5f, 2.5f, 1.1f, 12, 11, 2.0f),
    TITANIUM("Titanium", EnumMaterialTier.SUPER, 3034342, 2400, 8.0f, 6.0f, 2.0f, 1.0f, 24, 12, 1.0f),
    OSMIUM("Osmium", EnumMaterialTier.REGULAR, 9610936, 500, 7.0f, 4.0f, 2.0f, 1.2f, 17, 10, 1.0f),
    BRONZE("Bronze", EnumMaterialTier.REGULAR, 16733184, 500, 6.0f, 2.0f, 1.0f, 1.1f, 17, 14, 1.0f),
    BRASS("Brass", EnumMaterialTier.REGULAR, 0xFFAA33, 200, 5.0f, 1.0f, 2.0f, 1.1f, 12, 14, 2.0f),
    STEEL("Steel", EnumMaterialTier.REGULAR, 0x606060, 1000, 8.0f, 4.0f, 2.0f, 0.8f, 20, 9, 1.0f),
    INVAR("Invar", EnumMaterialTier.REGULAR, 14024652, 450, 7.0f, 3.0f, 3.0f, 1.0f, 18, 10, 2.0f),
    ELECTRUM("Electrum", EnumMaterialTier.REGULAR, 0xFFFF80, 100, 14.0f, 1.0f, 4.0f, 1.2f, 15, 20, 3.0f),
    ENDERIUM("Enderium", EnumMaterialTier.SUPER, 4623477, 2304, 18.0f, 12.0f, 5.0f, 1.0f, 22, 13, 2.0f),
    PRISMARINIUM("Prismarinium", EnumMaterialTier.SUPER, 10944466, 2816, 24.0f, 5.0f, 12.0f, 1.1f, 26, 17, 3.0f),
    COBALT("Cobalt", EnumMaterialTier.SUPER, 2455490, 1152, 14.0f, 5.1f, 4.6f, 1.1f, 20, 15, 3.0f),
    ARDITE("Ardite", EnumMaterialTier.SUPER, 9641227, 1792, 4.5f, 4.6f, 5.1f, 1.0f, 20, 16, 2.0f),
    MANYULLYN("Manyullyn", EnumMaterialTier.SUPER, 9453048, 896, 9.1f, 9.8f, 6.6f, 1.0f, 24, 17, 3.0f),
    MITHRIL("Mithril", EnumMaterialTier.REGULAR, 1473760, 800, 8.0f, 3.0f, 7.0f, 1.2f, 15, 12, 2.0f),
    ADAMANTIUM("Adamantium", EnumMaterialTier.REGULAR, 1480227, 1150, 14.0f, 7.0f, 3.0f, 1.0f, 19, 3, 1.0f),
    THYRIUM("Thyrium", EnumMaterialTier.SUPER, 5221010, 2000, 22.0f, 6.0f, 8.0f, 1.4f, 20, 28, 2.0f),
    SINISITE("Sinisite", EnumMaterialTier.SUPER, 1447550, 4100, 18.0f, 8.0f, 6.0f, 1.2f, 24, 11, 1.0f);

    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;

    private EnumPartMetal(String name, EnumMaterialTier tier, int color, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        return new ItemStack((Item)ModItems.ingot, 1, this.ordinal());
    }

    public String getCraftingOreName() {
        return "ingot" + this.name;
    }

    public int getHarvestLevel() {
        switch (this.tier) {
            case MUNDANE: {
                return 1;
            }
            case REGULAR: {
                return 2;
            }
            case SUPER: {
                return 4;
            }
        }
        return 0;
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartMetal part : EnumPartMetal.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule("metals", names.toArray(new String[names.size()]), (Object[])EnumPartMetal.values());
        for (EnumPartMetal metal : EnumPartMetal.values()) {
            if (!enabled[metal.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(metal));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }
}

