/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartCalculator implements IPartProperties
{
    REINFORCED_STONE("calc_reinforced_stone", EnumMaterialTier.MUNDANE, 0x404040, 1, 250, 5.0f, 1.5f, 0.5f, 1.0f, 10, 5, 1.0f),
    ENRICHED_GOLD("calc_enriched_gold", EnumMaterialTier.REGULAR, 12369050, 3, 1000, 8.0f, 0.0f, 7.0f, 1.3f, 14, 20, 3.0f),
    REINFORCED_IRON("calc_reinforced_iron", EnumMaterialTier.REGULAR, 0x7F7F7F, 2, 400, 7.0f, 2.0f, 1.0f, 1.1f, 17, 10, 1.0f),
    REDSTONE("calc_redstone", EnumMaterialTier.REGULAR, 12267592, 2, 800, 7.5f, 2.5f, 1.5f, 1.4f, 12, 18, 1.0f),
    WEAKENED_DIAMOND("calc_weakened_diamond", EnumMaterialTier.SUPER, 3568232, 3, 1400, 8.0f, 3.0f, 3.0f, 1.2f, 19, 10, 2.0f),
    FLAWLESS_DIAMOND("calc_flawless_diamond", EnumMaterialTier.SUPER, 11128006, 3, 1800, 14.0f, 5.0f, 5.0f, 1.2f, 23, 30, 2.0f),
    FIRE_DIAMOND("calc_fire_diamond", EnumMaterialTier.SUPER, 12267592, 3, 2600, 16.0f, 7.0f, 5.0f, 1.1f, 21, 30, 2.0f),
    ELECTRIC_DIAMOND("calc_electric_diamond", EnumMaterialTier.SUPER, 0xD2D2BB, 4, 10000, 18.0f, 10.0f, 12.0f, 1.1f, 23, 30, 2.0f),
    END_FORGED("calc_end_diamond", EnumMaterialTier.SUPER, 1135432, 6, 32766, 50.0f, 16.0f, 16.0f, 1.5f, 26, 30, 3.0f);

    public static final String MOD_ID = "calculator";
    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartCalculator(String name, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        String itemName = "calculator:";
        switch (this) {
            case ELECTRIC_DIAMOND: {
                itemName = itemName + "ElectricDiamond";
                break;
            }
            case END_FORGED: {
                itemName = itemName + "EndDiamond";
                break;
            }
            case ENRICHED_GOLD: {
                itemName = itemName + "EnrichedGoldIngot";
                break;
            }
            case FIRE_DIAMOND: {
                itemName = itemName + "FireDiamond";
                break;
            }
            case FLAWLESS_DIAMOND: {
                itemName = itemName + "FlawlessDiamond";
                break;
            }
            case REDSTONE: {
                itemName = itemName + "RedstoneIngot";
                break;
            }
            case REINFORCED_IRON: {
                itemName = itemName + "ReinforcedIronIngot";
                break;
            }
            case REINFORCED_STONE: {
                itemName = "sonarcore:ReinforcedStoneBlock";
                break;
            }
            case WEAKENED_DIAMOND: {
                itemName = itemName + "WeakenedDiamond";
            }
        }
        return new ItemStack(Item.func_111206_d((String)itemName));
    }

    public String getCraftingOreName() {
        switch (this) {
            case ENRICHED_GOLD: {
                return "ingotEnrichedGold";
            }
            case REINFORCED_STONE: {
                return "reinforcedStone";
            }
            case WEAKENED_DIAMOND: {
                return "gemDiamondFake";
            }
        }
        return "";
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartCalculator part : EnumPartCalculator.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule(MOD_ID, names.toArray(new String[names.size()]), (Object[])EnumPartCalculator.values());
        for (EnumPartCalculator part : EnumPartCalculator.values()) {
            if (!enabled[part.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

