/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.server;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkill;

public class ServerPacketHandlerSpellSkill
implements IMessageHandler<Packet, IMessage> {
    private static void processPacket(Packet message, EntityPlayerMP player, World world) {
        if (!player.hasCapability(CapabilityList.AOV, null)) {
            return;
        }
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        switch (message.id) {
            case CAST_SPELL: {
                Ability ability = cap.getSlot(message.object);
                if (ability == null) break;
                ability.cast((EntityPlayer)player);
                break;
            }
            case SKILLEDIT_CHECK_CANOBTAIN: {
                AoVSkill skillToCheck = AoVSkill.getSkillFromID(message.object);
                if (skillToCheck == null || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent()) || cap.getSkillPoints() < skillToCheck.getCost() || cap.getLevel() < skillToCheck.getLevel() || cap.getSpentSkillPoints() < skillToCheck.getSpentPoints() || skillToCheck.isClassCore() && cap.hasCoreSkill() || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent())) break;
                cap.addObtainedSkill(skillToCheck);
                cap.setSkillPoints(cap.getSkillPoints() - skillToCheck.getCost());
                break;
            }
            case RESETSKILLS_FULL: {
                cap.reset(true);
                break;
            }
            case RESETSKILLS_MINOR: {
                cap.reset(false);
                break;
            }
            case SPELLBAR_REMOVE: {
                cap.removeSlot(message.object);
                break;
            }
            case SPELLBAR_ADDNEAR: {
                cap.addToNearestSlot(message.ability);
                break;
            }
        }
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        MinecraftServer server = player.func_184102_h();
        if (server != null) {
            server.func_152344_a(() -> ServerPacketHandlerSpellSkill.processPacket(message, player, player.field_70170_p));
        }
        return null;
    }

    public static class Packet
    implements IMessage {
        public PacketType id;
        public int object;
        public AbilityBase ability;

        public Packet() {
        }

        public Packet(PacketType type, int data, @Nullable AbilityBase ability) {
            this.id = type;
            this.object = data;
            this.ability = ability;
        }

        public void fromBytes(ByteBuf buf) {
            PacketType[] types = PacketType.values();
            int i = buf.readInt();
            this.id = i >= types.length ? null : types[i];
            this.object = buf.readInt();
            this.ability = AbilityBase.getAbilityFromID(buf.readInt());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id.ordinal());
            buf.writeInt(this.object);
            buf.writeInt(AbilityBase.getID(this.ability));
        }

        public static enum PacketType {
            SKILLEDIT_CHECK_CANOBTAIN,
            RESETSKILLS_FULL,
            RESETSKILLS_MINOR,
            SPELLBAR_REMOVE,
            SPELLBAR_ADDNEAR,
            CAST_SPELL;

        }
    }
}

