/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.stun.IStunCapability;

public class ClientPacketHandlerStunned
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, World world) {
        Entity e = world.func_73045_a(message.entityID);
        if (e != null) {
            IStunCapability cap;
            IStunCapability iStunCapability = cap = e.hasCapability(CapabilityList.STUN, null) ? (IStunCapability)e.getCapability(CapabilityList.STUN, null) : null;
            if (cap != null) {
                cap.setStunTicks(message.stun);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerStunned.processPacket(message, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int entityID;
        private int stun;

        public Packet() {
        }

        public Packet(Entity entity, IStunCapability cap) {
            this.entityID = entity.func_145782_y();
            this.stun = cap.getStunTicks();
        }

        public void fromBytes(ByteBuf stream) {
            this.entityID = stream.readInt();
            this.stun = stream.readInt();
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.entityID);
            stream.writeInt(this.stun);
        }
    }
}

