/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVDamageSource;

public class ProjectileFlameStrike
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    private Entity attacker;
    private float damage = 2.0f;

    public ProjectileFlameStrike(World worldIn) {
        super(worldIn);
        this.func_70015_d(100);
        this.field_70159_w = 0.0;
        this.field_70181_x = -0.8;
        this.field_70179_y = 0.0;
        this.func_70101_b(0.0f, 90.0f);
    }

    public ProjectileFlameStrike(World world, Entity attacker) {
        this(world);
        this.attacker = attacker;
    }

    public ProjectileFlameStrike(World world, Entity attacker, float dmg) {
        this(world, attacker);
        this.damage = dmg;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void setDamage(float d) {
        this.damage = d;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
    }

    public void readSpawnData(ByteBuf data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public void func_70071_h_() {
        this.func_70030_z();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult ray = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
        if (ray != null && ray.field_72313_a != null) {
            switch (ray.field_72313_a) {
                case BLOCK: 
                case ENTITY: {
                    this.explode();
                    return;
                }
            }
        }
        this.field_70163_u += this.field_70181_x;
    }

    private void explode() {
        this.func_70106_y();
        for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c().func_177982_a(-10, -1, -10), this.func_180425_c().func_177982_a(10, 5, 10)))) {
            if (this.attacker != null) {
                IAoVCapability cap;
                IAoVCapability iAoVCapability = cap = this.attacker.hasCapability(CapabilityList.AOV, null) ? (IAoVCapability)this.attacker.getCapability(CapabilityList.AOV, null) : null;
                if (entity == this.attacker || cap != null && !IAoVCapability.selectiveTarget(this.attacker, cap, entity)) continue;
                if (cap != null) {
                    cap.addExp(this.attacker, 20, Abilities.flameStrike);
                }
            }
            entity.func_70015_d(15);
            entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76372_a, this.attacker), this.damage);
        }
        for (int i = 0; i < 2; ++i) {
            ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, CommonProxy.ParticleType.Fluff, this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), 10, -12058113);
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
    }
}

