/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.AbilityBase;

public abstract class ProjectileBase
extends EntityArrow
implements IProjectile,
IEntityAdditionalSpawnData {
    public Entity field_70250_c;
    private int ticksInAir;
    private double damage;
    private double speed = 0.5;
    private float range = 0.0f;
    private int maxRange = -1;
    private Vec3d startingPoint = this.func_174791_d();
    private AbilityBase parentSpell;
    private int color = -1;

    public ProjectileBase(World worldIn) {
        super(worldIn);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
        this.damage = 2.0;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70158_ak = true;
    }

    public ProjectileBase(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.startingPoint = this.func_174791_d();
    }

    public ProjectileBase(World worldIn, EntityLivingBase shooter) {
        this(worldIn, shooter, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v);
    }

    public ProjectileBase(World worldIn, EntityLivingBase shooter, double x, double y, double z) {
        this(worldIn);
        this.field_70250_c = shooter;
        this.func_70107_b(x, y + (double)shooter.func_70047_e(), z);
        this.startingPoint = this.func_174791_d();
        Vec3d vec = shooter.func_70676_i(1.0f);
        this.setTheVelocity(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public ProjectileBase(World worldIn, EntityLivingBase shooter, EntityLivingBase target, float dmg) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.field_70250_c = shooter;
        this.damage = dmg;
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        this.func_70186_c(d0, d1, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int c) {
        this.color = c;
    }

    public void setTheVelocity(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public AbilityBase getSpell() {
        return this.parentSpell;
    }

    public void setSpell(AbilityBase ability) {
        this.parentSpell = ability;
    }

    public void setMaxRange(int range) {
        this.maxRange = range;
    }

    public float getRange() {
        return this.range;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(int s) {
        this.speed = s;
    }

    public double func_70242_d() {
        return this.damage;
    }

    public void func_70239_b(double damageIn) {
        this.damage = damageIn;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
        buffer.writeDouble(this.damage);
        buffer.writeFloat(this.range);
        buffer.writeDouble(this.speed);
        buffer.writeInt(this.color);
    }

    public void readSpawnData(ByteBuf data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
        this.setDamageRangeSpeed(data.readDouble(), data.readFloat(), data.readDouble());
        this.setColor(data.readInt());
    }

    protected void func_70088_a() {
    }

    public boolean func_70241_g() {
        return false;
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70071_h_() {
        Object axisalignedbb;
        BlockPos blockpos;
        IBlockState iblockstate;
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 57.29577951308232);
        }
        if ((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb != null && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.blockHit(iblockstate, blockpos);
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        if (this.maxRange >= 0) {
            if (this.startingPoint.func_72438_d(this.func_174791_d()) >= (double)this.maxRange) {
                this.func_70106_y();
            }
        } else if (this.ticksInAir > 200) {
            this.func_70106_y();
        }
        for (Entity e : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(0.5))) {
            if (e == this || e == this.field_70250_c || !this.canHitEntity(e)) continue;
            this.onHit(e);
        }
        this.field_70165_t += this.field_70159_w * this.speed;
        this.field_70163_u += this.field_70181_x * this.speed;
        this.field_70161_v += this.field_70179_y * this.speed;
        float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = this.range;
        if (this.func_70090_H()) {
            this.func_70106_y();
            for (int l = 0; l < 4; ++l) {
                f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f1 = 0.6f;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        this.field_70181_x -= (double)f2;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected boolean canHitEntity(Entity entity) {
        IAoVCapability cap = entity.hasCapability(CapabilityList.AOV, null) ? (IAoVCapability)entity.getCapability(CapabilityList.AOV, null) : null;
        return entity instanceof EntityLivingBase && (cap == null || IAoVCapability.selectiveTarget(this.field_70250_c, cap, (EntityLivingBase)entity));
    }

    protected abstract DamageSource getDamageSource();

    protected abstract float getDamageAmp(double var1, Entity var3, Entity var4);

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
    }

    protected void onHit(Entity entity) {
        DamageSource damagesource = this.getDamageSource();
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, this.getDamageAmp(this.damage, this.field_70250_c, entity))) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                this.func_184548_a(entitylivingbase);
                if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                }
            }
            if (!(entity instanceof EntityEnderman)) {
                this.func_70106_y();
            }
        } else {
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
            if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected abstract void func_184548_a(EntityLivingBase var1);

    protected abstract void blockHit(IBlockState var1, BlockPos var2);

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("damage", this.damage);
        nbt.func_74776_a("range", this.range);
        nbt.func_74780_a("speed", this.speed);
        nbt.func_74768_a("maxRange", this.maxRange);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.damage = nbt.func_74769_h("damage");
        this.range = nbt.func_74760_g("range");
        this.speed = nbt.func_74769_h("speed");
        this.maxRange = nbt.func_74762_e("maxRange");
    }

    public void func_70100_b_(@Nonnull EntityPlayer p_70100_1_) {
    }

    public void setDamageRangeSpeed(double d, float r, double s) {
        this.damage = d;
        this.range = r;
        this.speed = s;
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }
}

