/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.skills;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.core.abilities.AbilityBase;

public abstract class AoVSkill {
    private static final List<AoVSkill> registry = Lists.newArrayList();
    private final List<AbilityBase> abilities;
    private final List<TextComponentTranslation> description = Lists.newArrayList();

    public AoVSkill(List<AbilityBase> spells, TextComponentTranslation ... desc) {
        this.description.clear();
        this.description.addAll(Arrays.asList(desc));
        this.abilities = spells;
        registry.add(this);
    }

    public static int getID(AoVSkill skill) {
        return registry.contains(skill) ? registry.indexOf(skill) : -1;
    }

    public static AoVSkill getSkillFromID(int id) {
        return id >= 0 && id < registry.size() ? registry.get(id) : null;
    }

    public final int getID() {
        return AoVSkill.getID(this);
    }

    public final List<AbilityBase> getAbilities() {
        return this.abilities;
    }

    public abstract int getCharges();

    public abstract int getSpellPower();

    public abstract int getDodge();

    public abstract int getDoubleStrike();

    public abstract boolean grantsSelectiveFocus();

    public abstract boolean isClassCore();

    public abstract AoVSkill getParent();

    public abstract int getCost();

    public abstract int getLevel();

    public abstract int getSpentPoints();

    public abstract ResourceLocation getIcon();

    @SideOnly(value=Side.CLIENT)
    public final List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        for (TextComponentTranslation s : this.description) {
            list.add(I18n.func_135052_a((String)s.func_150268_i(), (Object[])s.func_150271_j()));
        }
        return list;
    }
}

