/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.caster;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVDamageSource;

public class SlayLiving
extends AbilityBase {
    private static final int charges = 4;
    private static final int distance = 3;

    public SlayLiving() {
        super(new TextComponentTranslation(SlayLiving.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{4}), new TextComponentTranslation("aov.spells.global.range", new Object[]{3}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.slayliving.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.slayliving.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/slayliving.png");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)SlayLiving.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 6;
    }

    @Override
    public int getMaxCharges() {
        return 4;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 3.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (target == null) {
            return false;
        }
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap != null && !target.func_70662_br() && target.func_184222_aU()) {
            float damage = target.func_70681_au().nextInt((int)Math.floor(target.func_110143_aJ())) <= 4 ? target.func_110138_aP() : target.func_110138_aP() / 2.0f;
            target.func_70097_a(AoVDamageSource.createEntityDamageSource(AoVDamageSource.DESTRUCTION, (Entity)caster), damage *= 1.0f + cap.getSpellPower() / 100.0f);
            cap.addExp((Entity)caster, 20, Abilities.slayLiving);
            return true;
        }
        return false;
    }
}

