/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.caster;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.SoundEvents;

public class Destruction
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/destruction.png");
    private static final int charges = 2;
    private static final int distance = 20;

    public Destruction() {
        super(new TextComponentTranslation(Destruction.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{2}), new TextComponentTranslation("aov.spells.global.range", new Object[]{20}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.destruction.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.destruction.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Destruction.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 15;
    }

    @Override
    public int getMaxCharges() {
        return 2;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (target == null) {
            return false;
        }
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap != null && target.func_184222_aU()) {
            float damage = target.func_70681_au().nextInt((int)Math.floor(target.func_110143_aJ())) <= 8 ? target.func_110138_aP() : target.func_110138_aP() / 2.0f;
            target.func_70097_a(AoVDamageSource.createEntityDamageSource(AoVDamageSource.DESTRUCTION, (Entity)caster), damage *= 1.0f + cap.getSpellPower() / 100.0f);
            target.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.destruction, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            cap.addExp((Entity)caster, 20, Abilities.destruction);
            return true;
        }
        return false;
    }
}

