/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityCombust;
import tamaized.aov.registry.SoundEvents;

public class Combust
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/combust.png");
    private static final int charges = 6;
    private static final int distance = 32;
    private static final int damage = 2;

    public Combust() {
        super(new TextComponentTranslation(Combust.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{6}), new TextComponentTranslation("aov.spells.global.range", new Object[]{32}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{2}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.combust.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.combust.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Combust.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 3;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 32.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (!caster.hasCapability(CapabilityList.AOV, null) || target == null) {
            return false;
        }
        IAoVCapability aov = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (!caster.field_70170_p.field_72995_K && aov != null) {
            int a = (int)(2.0f * (1.0f + aov.getSpellPower() / 100.0f));
            EntityCombust spell = new EntityCombust(caster.field_70170_p, (Entity)caster, (Entity)target, a);
            caster.field_70170_p.func_72838_d((Entity)spell);
            SoundEvents.playMovingSoundOnServer(SoundEvents.malefic_hit, spell);
        }
        return true;
    }
}

