/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.core.abilities.Ability;

public abstract class AbilityBase {
    private static final List<AbilityBase> registry = Lists.newArrayList();
    private final List<TextComponentTranslation> description = Lists.newArrayList();

    public AbilityBase(TextComponentTranslation ... desc) {
        this.description.addAll(Arrays.asList(desc));
        registry.add(this);
    }

    public static int getID(AbilityBase skill) {
        return registry.contains(skill) ? registry.indexOf(skill) : -1;
    }

    public static AbilityBase getAbilityFromID(int id) {
        return id >= 0 && id < registry.size() ? registry.get(id) : null;
    }

    public final int getID() {
        return AbilityBase.getID(this);
    }

    public boolean shouldDisable(IAoVCapability cap, @Nullable IAstroCapability astro) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        for (TextComponentTranslation s : this.description) {
            Object[] args = new Object[s.func_150271_j().length];
            for (int index = 0; index < s.func_150271_j().length; ++index) {
                args[index] = I18n.func_135052_a((String)s.func_150271_j()[index].toString(), (Object[])new Object[0]);
            }
            list.add(I18n.func_135052_a((String)s.func_150268_i(), (Object[])args));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract String getName();

    public abstract int getMaxCharges();

    public abstract int getChargeCost();

    public abstract double getMaxDistance();

    public abstract int getCoolDown();

    public abstract boolean usesInvoke();

    public int getCost(IAoVCapability cap) {
        return this.usesInvoke() && cap.getInvokeMass() ? this.getChargeCost() * 2 : this.getChargeCost();
    }

    public abstract boolean cast(Ability var1, EntityPlayer var2, EntityLivingBase var3);

    public abstract ResourceLocation getIcon();

    static final class NullAbility
    extends AbilityBase {
        private final String name;

        public NullAbility(String name) {
            super(new TextComponentTranslation[0]);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxCharges() {
            return 0;
        }

        @Override
        public int getChargeCost() {
            return 0;
        }

        @Override
        public double getMaxDistance() {
            return 0.0;
        }

        @Override
        public int getCoolDown() {
            return 0;
        }

        @Override
        public boolean usesInvoke() {
            return false;
        }

        @Override
        public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
            return false;
        }

        @Override
        public ResourceLocation getIcon() {
            return null;
        }
    }
}

