/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.commands;

import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.gui.GuiHandler;

public class CommandAoV
extends CommandBase {
    private static IAoVCapability getCap(Entity e) {
        return e != null && e.hasCapability(CapabilityList.AOV, null) ? (IAoVCapability)e.getCapability(CapabilityList.AOV, null) : null;
    }

    @Nonnull
    public String func_71517_b() {
        return "aov";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.aov.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "open": {
                    if (sender.func_174793_f() instanceof EntityPlayer) {
                        GuiHandler.openGUI(0, (EntityPlayer)sender.func_174793_f(), sender.func_130014_f_());
                    }
                    return;
                }
                case "setlevel": {
                    if (args.length > 1) {
                        IAoVCapability cap;
                        Entity e;
                        int level;
                        try {
                            level = MathHelper.func_76125_a((int)Integer.parseInt(args[1]), (int)0, (int)15);
                        }
                        catch (NumberFormatException e2) {
                            throw new WrongUsageException("commands.aov.error.level", new Object[0]);
                        }
                        if (args.length > 2) {
                            e = CommandAoV.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                            cap = CommandAoV.getCap(e);
                        } else {
                            e = sender.func_174793_f();
                            cap = CommandAoV.getCap(e);
                        }
                        if (cap != null) {
                            cap.reset(true);
                            cap.setExp(AoVCapabilityHandler.getExpForLevel(level));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.aov.success.level", new Object[]{e.func_70005_c_(), level}));
                        }
                        return;
                    }
                    throw new WrongUsageException("commands.aov.usage.setlevel", new Object[0]);
                }
                case "reset": {
                    ResetType type = null;
                    if (args.length > 1) {
                        switch (args[1].toLowerCase()) {
                            case "minor": {
                                type = ResetType.MINOR;
                                break;
                            }
                            case "full": {
                                type = ResetType.MAJOR;
                            }
                        }
                    }
                    Object cap = CommandAoV.getCap(args.length > 2 ? CommandAoV.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[2]) : sender.func_174793_f());
                    if (type != null && cap != null) {
                        cap.reset(type == ResetType.MAJOR);
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.aov.success.reset", new Object[0]));
                        return;
                    }
                    throw new WrongUsageException("commands.aov.usage.reset", new Object[0]);
                }
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    public int func_82362_a() {
        return 3;
    }

    static enum ResetType {
        MINOR,
        MAJOR;

    }
}

