/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.astro;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public interface IAstroCapability {
    public static final ResourceLocation ID = new ResourceLocation("aov", "AstroCapabilityHandler");

    public void markDirty();

    public IAnimation[] getAnimations();

    public void playAnimation(EntityLivingBase var1, IAnimation var2);

    public void updateFrameData(float[][] var1);

    public float[][] getFrameData();

    public void drawCard(EntityLivingBase var1);

    public void redrawCard(EntityLivingBase var1);

    public void burnCard(EntityLivingBase var1);

    public void spreadCard(EntityLivingBase var1);

    public int getDrawTime();

    public void setDrawTime(int var1);

    @Nullable
    public ICard getDraw();

    public void setDraw(ICard var1);

    @Nullable
    public ICard getBurn();

    public void setBurn(ICard var1);

    @Nullable
    public ICard getSpread();

    public void setSpread(ICard var1);

    public void useDraw(EntityLivingBase var1);

    public void useSpread(EntityLivingBase var1);

    public void update(EntityLivingBase var1);

    public void sendPacketUpdates(EntityPlayer var1);

    public static enum ICard {
        Balance,
        Bole,
        Arrow,
        Spear,
        Ewer,
        Spire;

        public static final ICard[] cards;
        private static final Random rand;

        public static ICard getRandomCard() {
            return cards[rand.nextInt(cards.length)];
        }

        public static int getCardID(ICard card) {
            return card == null ? -1 : card.ordinal();
        }

        public static ICard getCardFromID(int id) {
            return id < 0 || id >= cards.length ? null : cards[id];
        }

        static {
            cards = ICard.values();
            rand = new Random();
        }
    }

    public static enum IAnimation {
        Draw,
        Burn,
        Spread,
        Activate,
        Redraw;

        public static final IAnimation[] values;

        public static IAnimation getAnimationFromID(int id) {
            if (id >= 0 && id < values.length) {
                return IAnimation.values()[id];
            }
            return null;
        }

        public static int getAnimationID(IAnimation animation) {
            return animation == null ? -1 : animation.ordinal();
        }

        static {
            values = IAnimation.values();
        }
    }
}

