/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tamaized.aov.client.gui.AoVUIBar;
import tamaized.aov.client.handler.ClientTicker;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.config.ConfigHandler;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.proxy.ClientProxy;

public class AoVOverlay
extends Gui {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation TEXTURE_ASTRO = new ResourceLocation("aov", "textures/gui/astro.png");

    @SubscribeEvent
    public void RenderAoVData(RenderGameOverlayEvent.Post e) {
        if (e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        ClientTicker.update();
        IAoVCapability cap = (IAoVCapability)AoVOverlay.mc.field_71439_g.getCapability(CapabilityList.AOV, null);
        FontRenderer fontRender = AoVOverlay.mc.field_71466_p;
        ScaledResolution sr = new ScaledResolution(mc);
        int sW = sr.func_78326_a() / 2;
        if (cap != null && cap.hasCoreSkill()) {
            if (ClientProxy.barToggle) {
                GlStateManager.func_179094_E();
                if (ConfigHandler.renderBarOverHotbar) {
                    GlStateManager.func_179109_b((float)0.0f, (float)(sr.func_78328_b() - 23), (float)0.0f);
                }
                for (int i = 0; i < 9; ++i) {
                    int x = sW - 90 + 20 * i;
                    int y = ConfigHandler.renderBarOverHotbar || ConfigHandler.renderChargesAboveSpellbar ? 1 - ClientTicker.charges.getValue(i) : 1 + ClientTicker.charges.getValue(i);
                    this.renderCharges(x + ConfigHandler.elementPositions.spellbar_x, y + ConfigHandler.elementPositions.spellbar_y, fontRender, cap, i);
                }
                GlStateManager.func_179121_F();
            }
            AoVUIBar.render(this, ConfigHandler.elementPositions.spellbar_x, ConfigHandler.elementPositions.spellbar_y);
            if (cap.getCoreSkill() == AoVSkills.astro_core_1) {
                this.renderAstro((EntityPlayer)AoVOverlay.mc.field_71439_g, sr);
            }
        }
    }

    private void renderCharges(int x, int y, FontRenderer fontRender, IAoVCapability cap, int index) {
        int val;
        Ability ability = cap.getSlot(index);
        int n = val = ability == null ? -1 : ability.getCharges();
        if (val < 0) {
            return;
        }
        int w = 20;
        int h = 20;
        AoVOverlay.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)(!cap.canUseAbility(ability) ? 0x77FF0000 : 1996536831));
        this.drawCenteredStringNoShadow(fontRender, String.valueOf(val), x + 10, y + (ConfigHandler.renderBarOverHotbar || ConfigHandler.renderChargesAboveSpellbar ? 3 : 10), 0);
    }

    private void drawCenteredStringNoShadow(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175065_a(text, (float)(x - fontRendererIn.func_78256_a(text) / 2), (float)y, color, false);
    }

    private void renderAstro(EntityPlayer player, ScaledResolution sr) {
        if (!player.hasCapability(CapabilityList.ASTRO, null)) {
            return;
        }
        IAstroCapability cap = (IAstroCapability)player.getCapability(CapabilityList.ASTRO, null);
        if (cap == null) {
            return;
        }
        if (!ConfigHandler.renderAstro && cap.getDraw() == null && cap.getBurn() == null && cap.getSpread() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(TEXTURE_ASTRO);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float x = sr.func_78326_a() * 2 / 3;
        float y = sr.func_78328_b() / 5;
        float scale = 0.35f;
        buffer.func_181662_b((double)(x += (float)ConfigHandler.elementPositions.astro_x), (double)((y += (float)ConfigHandler.elementPositions.astro_y) + 143.0f * scale), 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(x + 235.0f * scale), (double)(y + 143.0f * scale), 0.0).func_187315_a(0.5, 0.5).func_181675_d();
        buffer.func_181662_b((double)(x + 235.0f * scale), (double)y, 0.0).func_187315_a(0.5, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        if (cap.getDraw() != null) {
            this.renderAstroIcon(IAstroCapability.ICard.getCardID(cap.getDraw()), buffer, x + 33.5f, y + 17.0f, scale);
            this.func_73732_a(AoVOverlay.mc.field_71466_p, "" + cap.getDrawTime(), (int)(x + 43.0f), (int)(y + 50.0f), 12418576);
            mc.func_110434_K().func_110577_a(TEXTURE_ASTRO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (cap.getSpread() != null) {
            this.renderAstroIcon(IAstroCapability.ICard.getCardID(cap.getSpread()), buffer, x + 14.0f, y + 20.0f, scale * 0.8f);
        }
        if (cap.getBurn() != null) {
            this.renderAstroRoyalRoadIcon((int)Math.floor(IAstroCapability.ICard.getCardID(cap.getBurn()) / 2), buffer, x + 55.0f, y - 7.5f, scale);
        }
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void renderAstroIcon(int index, BufferBuilder buffer, float x, float y, float scale) {
        float xOffset = 0.25f * (float)(index % 4);
        float yOffset = 0.25f * (float)Math.floor(index / 4);
        buffer.func_181662_b((double)x, (double)(y + 286.0f * (scale /= 4.0f)), 0.0).func_187315_a((double)(0.5f * xOffset), (double)(0.75f + yOffset)).func_181675_d();
        buffer.func_181662_b((double)(x + 235.0f * scale), (double)(y + 286.0f * scale), 0.0).func_187315_a((double)(0.5f * (0.25f + xOffset)), (double)(0.75f + yOffset)).func_181675_d();
        buffer.func_181662_b((double)(x + 235.0f * scale), (double)y, 0.0).func_187315_a((double)(0.5f * (0.25f + xOffset)), (double)(0.5f + yOffset)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(0.5f * xOffset), (double)(0.5f + yOffset)).func_181675_d();
    }

    private void renderAstroRoyalRoadIcon(int index, BufferBuilder buffer, float x, float y, float scale) {
        float xOffset = 0.15f + 0.084f * (float)index;
        float yOffset = 0.0f;
        buffer.func_181662_b((double)(x + 80.0f * (scale *= 0.6f)), (double)y, 0.0).func_187315_a((double)(0.5f + xOffset), (double)(0.0f + yOffset)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(0.5f + (0.08f + xOffset)), (double)(0.0f + yOffset)).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + 286.0f * scale), 0.0).func_187315_a((double)(0.5f + (0.08f + xOffset)), (double)(0.5f + yOffset)).func_181675_d();
        buffer.func_181662_b((double)(x + 80.0f * scale), (double)(y + 286.0f * scale), 0.0).func_187315_a((double)(0.5f + xOffset), (double)(0.5f + yOffset)).func_181675_d();
        if (ConfigHandler.renderRoyalRoad) {
            GlStateManager.func_179094_E();
            this.func_73732_a(AoVOverlay.mc.field_71466_p, I18n.func_135052_a((String)("aov.astro.burn." + index), (Object[])new Object[0]), (int)x - 16, (int)y, index == 0 ? 43775 : (index == 1 ? 65450 : 0xFFDD88));
            GlStateManager.func_179121_F();
            mc.func_110434_K().func_110577_a(TEXTURE_ASTRO);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

