/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks.tiles.TotemLogic;

import com.corwinjv.mobtotems.TotemHelper;
import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.tiles.OfferingBoxTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.Modifiers;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.TotemLogic;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnderLogic
extends TotemLogic {
    @Override
    public List<ItemStack> getCost() {
        ArrayList<ItemStack> cost = new ArrayList<ItemStack>();
        cost.add(new ItemStack((Block)Blocks.field_150349_c, 1, 0));
        return cost;
    }

    @Override
    @Nonnull
    public TotemLogic.EffectType getEffectType() {
        return TotemLogic.EffectType.EFFECT;
    }

    public static class EnderTotemEnderTeleportEvent {
        private static final int DEFAULT_RADIUS = 32;
        private static final int RANGE_BOOST = 16;

        @SubscribeEvent
        public void onEnderTeleportEvent(EnderTeleportEvent e) {
            World world = e.getEntityLiving().func_130014_f_();
            if (!world.field_72995_K) {
                ArrayList loadedTileEntityList = new ArrayList(world.field_147482_g);
                for (TileEntity tileEntity : loadedTileEntityList) {
                    if (!(tileEntity instanceof OfferingBoxTileEntity) || ((OfferingBoxTileEntity)tileEntity).getChargeLevel() <= 0 || !TotemHelper.hasTotemType((OfferingBoxTileEntity)tileEntity, TotemType.ENDER)) continue;
                    Modifiers modifiers = TotemHelper.getModifiers(world, (OfferingBoxTileEntity)tileEntity);
                    int radius = 32 + (int)(16.0f * modifiers.range);
                    if (this.isMobAffected(tileEntity.func_174877_v(), e.getEntity(), radius)) continue;
                    BlockPos validPos = this.getValidTeleportPosAround(world, tileEntity.func_174877_v());
                    if (validPos == null) break;
                    e.setTargetX((double)validPos.func_177958_n());
                    e.setTargetY((double)validPos.func_177956_o());
                    e.setTargetZ((double)validPos.func_177952_p());
                    break;
                }
            }
        }

        private boolean isMobAffected(BlockPos pos, Entity mob, int radius) {
            double dist = mob.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return !(mob instanceof EntityEnderman) || !(dist < (double)radius);
        }

        private BlockPos getValidTeleportPosAround(World world, BlockPos pos) {
            BlockPos validPos = null;
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos posToCheck = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z);
                    if (!world.func_180495_p(posToCheck).func_177230_c().equals(Blocks.field_150350_a)) continue;
                    validPositions.add(posToCheck);
                }
            }
            int idx = (int)(Math.random() * (double)(validPositions.size() - 1));
            validPos = (BlockPos)validPositions.get(idx);
            return validPos;
        }
    }
}

