/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RouterSettingsMessage
implements IMessage {
    private boolean eco;
    private TileEntityItemRouter router;
    private RouterRedstoneBehaviour rrb;

    public RouterSettingsMessage() {
    }

    public RouterSettingsMessage(TileEntityItemRouter router) {
        this.router = router;
        this.rrb = router.getRedstoneBehaviour();
        this.eco = router.getEcoMode();
    }

    public void fromBytes(ByteBuf byteBuf) {
        BlockPos pos = new BlockPos(byteBuf.readInt(), byteBuf.readInt(), byteBuf.readInt());
        WorldServer world = DimensionManager.getWorld((int)byteBuf.readInt());
        if (world != null) {
            this.router = TileEntityItemRouter.getRouterAt((IBlockAccess)world, pos);
        }
        this.rrb = RouterRedstoneBehaviour.values()[byteBuf.readByte()];
        this.eco = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.router.func_174877_v().func_177958_n());
        byteBuf.writeInt(this.router.func_174877_v().func_177956_o());
        byteBuf.writeInt(this.router.func_174877_v().func_177952_p());
        byteBuf.writeInt(this.router.func_145831_w().field_73011_w.getDimension());
        byteBuf.writeByte(this.rrb.ordinal());
        byteBuf.writeBoolean(this.eco);
    }

    public static class Handler
    implements IMessageHandler<RouterSettingsMessage, IMessage> {
        public IMessage onMessage(RouterSettingsMessage msg, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_();
            mainThread.func_152344_a(() -> {
                if (msg.router != null) {
                    msg.router.setRedstoneBehaviour(msg.rrb);
                    msg.router.setEcoMode(msg.eco);
                }
            });
            return null;
        }
    }
}

