/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.item.module.Module;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.CountedItemStacks;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class CompiledModule {
    private final Filter filter;
    private final Module module;
    private final Module.RelativeDirection direction;
    private final ModuleTarget target;
    private final RouterRedstoneBehaviour behaviour;
    private final boolean termination;
    private final EnumFacing facing;
    private final EnumFacing routerFacing;
    private final int regulationAmount;
    private final ItemAugment.AugmentCounter augmentCounter;
    private final int range;
    private final int rangeSquared;
    private int lastMatchPos = 0;

    public CompiledModule(TileEntityItemRouter router, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemModule)) {
            throw new IllegalArgumentException("expected module router module, got " + stack);
        }
        this.module = ItemModule.getModule(stack);
        this.augmentCounter = new ItemAugment.AugmentCounter(stack);
        this.direction = ModuleHelper.getDirectionFromNBT(stack);
        this.range = this.module instanceof IRangedModule ? ((IRangedModule)((Object)this.module)).getCurrentRange(this.getRangeModifier()) : 0;
        this.rangeSquared = this.range * this.range;
        this.target = this.setupTarget(router, stack);
        this.filter = new Filter(this.target, stack);
        this.termination = ModuleHelper.terminates(stack);
        this.behaviour = ModuleHelper.getRedstoneBehaviour(stack);
        this.regulationAmount = ModuleHelper.getRegulatorAmount(stack);
        this.facing = router == null ? null : router.getAbsoluteFacing(this.direction);
        this.routerFacing = router == null ? null : router.getAbsoluteFacing(Module.RelativeDirection.FRONT);
    }

    public abstract boolean execute(TileEntityItemRouter var1);

    public Module getModule() {
        return this.module;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Module.RelativeDirection getDirection() {
        return this.direction;
    }

    public ModuleTarget getTarget() {
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public boolean termination() {
        return this.termination;
    }

    public RouterRedstoneBehaviour getRedstoneBehaviour() {
        return this.behaviour;
    }

    int getRegulationAmount() {
        return this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.REGULATOR) > 0 ? this.regulationAmount : 0;
    }

    public int getAugmentCount(ItemAugment.AugmentType augmentType) {
        return this.augmentCounter.getAugmentCount(augmentType);
    }

    EnumFacing getFacing() {
        return this.facing;
    }

    public void onCompiled(TileEntityItemRouter router) {
        if (this.behaviour == RouterRedstoneBehaviour.PULSE) {
            router.setHasPulsedModules(true);
        }
    }

    public void cleanup(TileEntityItemRouter router) {
    }

    private int getLastMatchPos(int offset, int size) {
        int pos = this.lastMatchPos + offset;
        if (pos >= size) {
            pos -= size;
        }
        return pos;
    }

    private void setLastMatchPos(int lastMatchPos) {
        this.lastMatchPos = lastMatchPos;
    }

    protected ModuleTarget setupTarget(TileEntityItemRouter router, ItemStack stack) {
        if (router == null || this.module.isDirectional() && this.direction == Module.RelativeDirection.NONE) {
            return null;
        }
        EnumFacing facing = router.getAbsoluteFacing(this.direction);
        BlockPos pos = router.func_174877_v().func_177972_a(facing);
        String blockName = BlockUtil.getBlockName(router.func_145831_w(), pos);
        int dim = router.func_145831_w().field_73011_w.getDimension();
        return new ModuleTarget(dim, router.func_174877_v().func_177972_a(facing), facing.func_176734_d(), blockName);
    }

    int getItemsPerTick(TileEntityItemRouter router) {
        int n = this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.STACK);
        return n > 0 ? Math.min(1 << n, 64) : router.getItemsPerTick();
    }

    int transferToRouter(IItemHandler handler, TileEntityItemRouter router) {
        ItemStack wanted;
        CountedItemStacks count = null;
        if (this.getRegulationAmount() > 0) {
            count = new CountedItemStacks(handler);
        }
        if ((wanted = this.findItemToPull(router, handler, this.getItemsPerTick(router), count)).func_190926_b()) {
            return 0;
        }
        if (count != null) {
            wanted.func_190920_e(Math.min(wanted.func_190916_E(), (Integer)count.getOrDefault(wanted, 0) - this.getRegulationAmount()));
            if (wanted.func_190926_b()) {
                return 0;
            }
        }
        int totalInserted = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int pos = this.getLastMatchPos(i, handler.getSlots());
            ItemStack toPull = handler.extractItem(pos, wanted.func_190916_E(), true);
            if (toPull.func_190926_b()) {
                this.setLastMatchPos((pos + 1) % handler.getSlots());
                return 0;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)wanted, (ItemStack)toPull)) continue;
            ItemStack notInserted = router.insertBuffer(toPull);
            int inserted = toPull.func_190916_E() - notInserted.func_190916_E();
            handler.extractItem(pos, inserted, false);
            wanted.func_190918_g(inserted);
            totalInserted += inserted;
            if (!wanted.func_190926_b() && !router.isBufferFull()) continue;
            this.setLastMatchPos(handler.getStackInSlot(pos).func_190926_b() ? (pos + 1) % handler.getSlots() : pos);
            return totalInserted;
        }
        return totalInserted;
    }

    private ItemStack findItemToPull(TileEntityItemRouter router, IItemHandler handler, int nToTake, CountedItemStacks count) {
        ItemStack stackInRouter = router.peekBuffer(1);
        ItemStack result = ItemStack.field_190927_a;
        if (!stackInRouter.func_190926_b() && this.getFilter().test(stackInRouter)) {
            result = stackInRouter.func_77946_l();
            result.func_190920_e(nToTake);
        } else if (stackInRouter.func_190926_b()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                int pos = this.getLastMatchPos(i, handler.getSlots());
                ItemStack stack = handler.getStackInSlot(pos);
                if (stack.func_190926_b() || !this.getFilter().test(stack) || count != null && (Integer)count.get(stack) <= this.getRegulationAmount()) continue;
                this.setLastMatchPos(pos);
                result = stack.func_77946_l();
                result.func_190920_e(nToTake);
                break;
            }
        }
        return result;
    }

    public ModuleTarget getActualTarget(TileEntityItemRouter router) {
        return this.getTarget();
    }

    public boolean shouldRun(boolean powered, boolean pulsed) {
        return this.getRedstoneBehaviour().shouldRun(powered, pulsed);
    }

    boolean isRegulationOK(TileEntityItemRouter router, boolean inbound) {
        if (this.regulationAmount == 0) {
            return true;
        }
        int items = router.getBufferItemStack().func_190926_b() ? 0 : router.getBufferItemStack().func_190916_E();
        return inbound && this.regulationAmount > items || !inbound && this.regulationAmount < items;
    }

    int getRange() {
        return this.range;
    }

    public int getRangeSquared() {
        return this.rangeSquared;
    }

    int getRangeModifier() {
        return this.getAugmentCount(ItemAugment.AugmentType.RANGE_UP) - this.getAugmentCount(ItemAugment.AugmentType.RANGE_DOWN);
    }

    public EnumFacing getRouterFacing() {
        return this.routerFacing;
    }

    public void onNeighbourChange(TileEntityItemRouter router) {
    }
}

