/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.ConfigHandler;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.PushEntityMessage;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CompiledExtruderModule
extends CompiledModule {
    public static final String NBT_EXTRUDER_DIST = "ExtruderDist";
    private static final double BASE_PUSH_STRENGTH = 0.55;
    private static final double AUGMENT_BOOST = 0.15;
    int distance;
    private final boolean silkTouch;

    public CompiledExtruderModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        this.distance = router == null ? 0 : router.getExtData().func_74762_e(NBT_EXTRUDER_DIST + this.getFacing());
        this.silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        boolean extend = this.shouldExtend(router);
        World world = router.func_145831_w();
        if (extend && !router.isBufferEmpty() && this.distance < this.getRange() && this.isRegulationOK(router, false)) {
            BlockPos placePos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance + 1);
            ItemStack toPlace = router.peekBuffer(1);
            IBlockState state = BlockUtil.tryPlaceAsBlock(toPlace, world, placePos, this.getFacing(), this.getRouterFacing());
            if (state != null) {
                router.extractBuffer(1);
                router.getExtData().func_74768_a(NBT_EXTRUDER_DIST + this.getFacing(), ++this.distance);
                if (ConfigHandler.module.extruderSound) {
                    router.playSound(null, placePos, state.func_177230_c().getSoundType(state, world, placePos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                this.tryPushEntities(router.func_145831_w(), placePos, this.getFacing());
                return true;
            }
        } else if (!extend && this.distance > 0 && this.isRegulationOK(router, true)) {
            BlockPos breakPos = router.func_174877_v().func_177967_a(this.getFacing(), this.distance);
            IBlockState oldState = world.func_180495_p(breakPos);
            Block oldBlock = oldState.func_177230_c();
            if (oldBlock.isAir(oldState, (IBlockAccess)world, breakPos) || oldBlock instanceof BlockLiquid || oldBlock instanceof IFluidBlock) {
                router.getExtData().func_74768_a(NBT_EXTRUDER_DIST + this.getFacing(), --this.distance);
                return false;
            }
            BlockUtil.BreakResult dropResult = BlockUtil.tryBreakBlock(world, breakPos, this.getFilter(), this.silkTouch, 0);
            if (dropResult.isBlockBroken()) {
                router.getExtData().func_74768_a(NBT_EXTRUDER_DIST + this.getFacing(), --this.distance);
                dropResult.processDrops(world, breakPos, router.getBuffer());
                if (ConfigHandler.module.extruderSound) {
                    router.playSound(null, breakPos, oldBlock.getSoundType(oldState, world, breakPos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                }
                return true;
            }
        }
        return false;
    }

    void tryPushEntities(World world, BlockPos placePos, EnumFacing facing) {
        if (!ConfigHandler.module.extruderPushEntities) {
            return;
        }
        int nPush = this.getAugmentCount(ItemAugment.AugmentType.PUSHING);
        Vec3d v = new Vec3d(facing.func_176730_m()).func_186678_a(0.55 + (double)nPush * 0.15);
        for (Entity entity : world.func_72872_a(Entity.class, new AxisAlignedBB(placePos))) {
            if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
            entity.field_70159_w = v.field_72450_a;
            entity.field_70181_x = v.field_72448_b;
            entity.field_70179_y = v.field_72449_c;
            entity.field_70122_E = false;
            entity.field_70132_H = false;
            entity.field_70123_F = false;
            entity.field_70124_G = false;
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70637_d(true);
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0);
            ModularRouters.network.sendToAllAround((IMessage)new PushEntityMessage(entity, v.field_72450_a, v.field_72448_b, v.field_72449_c), point);
        }
    }

    @Override
    public boolean shouldRun(boolean powered, boolean pulsed) {
        return true;
    }

    boolean shouldExtend(TileEntityItemRouter router) {
        switch (this.getRedstoneBehaviour()) {
            case ALWAYS: {
                return router.getRedstonePower() > 0;
            }
            case HIGH: {
                return router.getRedstonePower() == 15;
            }
            case LOW: {
                return router.getRedstonePower() == 0;
            }
        }
        return false;
    }
}

