/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.module.DetectorModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CompiledDetectorModule
extends CompiledModule {
    public static final String NBT_SIGNAL_LEVEL = "SignalLevel";
    public static final String NBT_STRONG_SIGNAL = "StrongSignal";
    private final int signalLevel;
    private final boolean strongSignal;

    public CompiledDetectorModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        NBTTagCompound compound = this.setupNBT(stack);
        this.signalLevel = compound == null ? 0 : (int)compound.func_74771_c(NBT_SIGNAL_LEVEL);
        this.strongSignal = compound != null && compound.func_74767_n(NBT_STRONG_SIGNAL);
    }

    @Override
    public boolean hasTarget() {
        return true;
    }

    @Override
    public boolean execute(TileEntityItemRouter router) {
        ItemStack stack = router.getBufferItemStack();
        if (!this.getFilter().test(stack)) {
            return false;
        }
        router.emitRedstone(this.getDirection(), this.getSignalLevel(), DetectorModule.SignalType.getType(this.isStrongSignal()));
        return true;
    }

    private NBTTagCompound setupNBT(ItemStack stack) {
        NBTTagCompound compound = ModuleHelper.validateNBT(stack);
        if (!compound.func_74764_b(NBT_SIGNAL_LEVEL)) {
            compound.func_74768_a(NBT_SIGNAL_LEVEL, 15);
        }
        if (!compound.func_74764_b(NBT_STRONG_SIGNAL)) {
            compound.func_74757_a(NBT_STRONG_SIGNAL, false);
        }
        return compound;
    }

    public int getSignalLevel() {
        return this.signalLevel;
    }

    public boolean isStrongSignal() {
        return this.strongSignal;
    }

    @Override
    public void onCompiled(TileEntityItemRouter router) {
        super.onCompiled(router);
        router.setAllowRedstoneEmission(true);
    }

    @Override
    public void cleanup(TileEntityItemRouter router) {
        super.cleanup(router);
        router.setAllowRedstoneEmission(false);
    }
}

