/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.item.upgrade.Upgrade;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class SecurityUpgrade
extends Upgrade {
    private static final String NBT_PLAYERS = "Players";
    private static final int MAX_PLAYERS = 6;

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        list.add(I18n.func_135052_a((String)"itemText.security.owner", (Object[])new Object[]{TextFormatting.YELLOW + SecurityUpgrade.getOwnerName(itemstack)}));
        Set<String> names = SecurityUpgrade.getPlayerNames(itemstack);
        if (!names.isEmpty()) {
            list.add(I18n.func_135052_a((String)"itemText.security.count", (Object[])new Object[]{names.size(), 6}));
            list.addAll(names.stream().map(name -> " \u2022 " + TextFormatting.YELLOW + name).sorted().collect(Collectors.toList()));
        }
    }

    @Override
    public void onCompiled(ItemStack stack, TileEntityItemRouter router) {
        super.onCompiled(stack, router);
        router.addPermittedIds(SecurityUpgrade.getPlayerIDs(stack));
    }

    @Override
    public Color getItemTint() {
        return new Color(64, 64, 255);
    }

    private static Set<UUID> getPlayerIDs(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return Collections.emptySet();
        }
        HashSet res = Sets.newHashSet();
        Pair<String, UUID> owner = ModuleHelper.getOwnerNameAndId(stack);
        res.add(owner.getRight());
        if (compound.func_74764_b(NBT_PLAYERS)) {
            NBTTagCompound p = compound.func_74775_l(NBT_PLAYERS);
            res.addAll(p.func_150296_c().stream().map(UUID::fromString).collect(Collectors.toList()));
        }
        return res;
    }

    private static String getOwnerName(ItemStack stack) {
        Pair<String, UUID> owner = ModuleHelper.getOwnerNameAndId(stack);
        return ((String)owner.getLeft()).isEmpty() ? "???" : (String)owner.getLeft();
    }

    private static Set<String> getPlayerNames(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b(NBT_PLAYERS)) {
            NBTTagCompound p = compound.func_74775_l(NBT_PLAYERS);
            return Sets.newHashSet((Iterable)p.func_150296_c().stream().map(arg_0 -> ((NBTTagCompound)p).func_74779_i(arg_0)).sorted().collect(Collectors.toList()));
        }
        return Collections.emptySet();
    }

    private static Interacted.Result addPlayer(ItemStack stack, String id, String name) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            NBTTagCompound p;
            if (!compound.func_74764_b(NBT_PLAYERS)) {
                compound.func_74782_a(NBT_PLAYERS, (NBTBase)new NBTTagCompound());
            }
            if ((p = compound.func_74775_l(NBT_PLAYERS)).func_74764_b(id)) {
                return Interacted.Result.ALREADY_ADDED;
            }
            if (p.func_186856_d() >= 6) {
                return Interacted.Result.FULL;
            }
            p.func_74778_a(id, name);
            return Interacted.Result.ADDED;
        }
        return Interacted.Result.ERROR;
    }

    private static Interacted.Result removePlayer(ItemStack stack, String id) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            NBTTagCompound p;
            if (!compound.func_74764_b(NBT_PLAYERS)) {
                compound.func_74782_a(NBT_PLAYERS, (NBTBase)new NBTTagCompound());
            }
            if ((p = compound.func_74775_l(NBT_PLAYERS)).func_74764_b(id)) {
                p.func_82580_o(id);
                return Interacted.Result.REMOVED;
            }
            return Interacted.Result.NOT_PRESENT;
        }
        return Interacted.Result.ERROR;
    }

    @Mod.EventBusSubscriber
    public static class Interacted {
        @SubscribeEvent
        public static void onInteracted(PlayerInteractEvent.RightClickBlock event) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184586_b(event.getHand());
            if (!player.func_130014_f_().field_72995_K && ItemUpgrade.isType(stack, ItemUpgrade.UpgradeType.SECURITY) && player.func_70093_af()) {
                ModuleHelper.setOwner(stack, player);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("itemText.security.owner", new Object[]{player.getDisplayNameString()}), false);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onInteracted(PlayerInteractEvent.EntityInteract event) {
            ItemStack stack;
            if (event.getTarget() instanceof EntityPlayer && ItemUpgrade.isType(stack = event.getEntityPlayer().func_184586_b(event.getHand()), ItemUpgrade.UpgradeType.SECURITY)) {
                Result res;
                EntityPlayer targetPlayer = (EntityPlayer)event.getTarget();
                String id = targetPlayer.func_110124_au().toString();
                String name = targetPlayer.getDisplayNameString();
                Result result = res = event.getEntityPlayer().func_70093_af() ? SecurityUpgrade.removePlayer(stack, id) : SecurityUpgrade.addPlayer(stack, id, name);
                if (event.getWorld().field_72995_K) {
                    event.getEntityPlayer().func_184185_a(res.isError() ? RegistrarMR.SOUND_ERROR : RegistrarMR.SOUND_SUCCESS, 1.0f, 1.0f);
                } else {
                    event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("chatText.security." + res.toString(), new Object[]{name}), false);
                }
                event.setCanceled(true);
            }
        }

        static enum Result {
            ADDED,
            REMOVED,
            FULL,
            ALREADY_ADDED,
            ERROR,
            NOT_PRESENT;


            boolean isError() {
                return this != ADDED && this != REMOVED;
            }
        }
    }
}

