/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidget;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class FloatTextField
extends TextFieldWidget {
    private final float min;
    private final float max;
    private float incr = 1.0f;
    private float fine = 0.1f;
    private float coarse = 5.0f;
    private String precStr = "%.1f";

    public FloatTextField(TextFieldManager parent, int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height, float min, float max) {
        super(parent, componentId, fontrendererObj, x, y, par5Width, par6Height);
        this.min = min;
        this.max = max;
        this.func_146203_f(5);
        this.func_175205_a(input -> {
            if (input == null || input.isEmpty() || input.equals("-")) {
                return true;
            }
            try {
                float f = Float.parseFloat(input);
                return f >= this.min && f <= this.max;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public void setIncr(float incr, float fine, float coarse) {
        this.incr = incr;
        this.fine = fine;
        this.coarse = coarse;
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        switch (keyCode) {
            case 200: {
                return this.adjustField(this.incr);
            }
            case 208: {
                return this.adjustField(-this.incr);
            }
        }
        return super.func_146201_a(typedChar, keyCode);
    }

    @Override
    public void onMouseWheel(int direction) {
        this.adjustField(direction > 0 ? this.incr : -this.incr);
    }

    public void setValue(float newVal) {
        if (newVal >= this.min && newVal <= this.max) {
            this.func_146180_a(String.format(this.precStr, Float.valueOf(newVal)));
        }
    }

    public void setPrecision(int precision) {
        this.precStr = "%." + precision + "f";
    }

    private boolean adjustField(float adj) {
        if (GuiScreen.func_146271_m()) {
            adj *= this.fine;
        } else if (GuiScreen.func_146272_n()) {
            adj *= this.coarse;
        }
        float val = Float.parseFloat(this.func_146179_b());
        float newVal = Math.max(this.min, Math.min(this.max, val + adj));
        if (newVal != val) {
            this.func_146180_a("");
            this.func_146191_b(String.format(this.precStr, Float.valueOf(newVal)));
        }
        return true;
    }
}

