/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.logic.compiled.CompiledVacuumModule;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.UniversalBucket;

public class GuiModuleVacuum
extends GuiModule {
    private static final int XP_TYPE_BUTTON_ID = 1000;
    private static final int EJECT_BUTTON_ID = 1001;
    private XPTypeButton xpb;
    private EjectButton ejb;
    private XPCollection.XPCollectionType xpCollectionType;
    private boolean autoEject;

    public GuiModuleVacuum(ContainerModule containerItem, EnumHand hand) {
        this(containerItem, null, -1, hand);
    }

    public GuiModuleVacuum(ContainerModule containerItem, BlockPos routerPos, Integer slotIndex, EnumHand hand) {
        super(containerItem, routerPos, slotIndex, hand);
        CompiledVacuumModule vac = new CompiledVacuumModule(null, this.moduleItemStack);
        this.xpCollectionType = vac.getXPCollectionType();
        this.autoEject = vac.isAutoEjecting();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ItemStack[] xpTypeIcons = (ItemStack[])Arrays.stream(XPCollection.XPCollectionType.values()).map(XPCollection.XPCollectionType::getIcon).toArray(ItemStack[]::new);
        this.xpb = new XPTypeButton(1000, this.field_147003_i + 170, this.field_147009_r + 28, 16, 16, true, xpTypeIcons, this.xpCollectionType);
        this.field_146292_n.add(this.xpb);
        this.ejb = new EjectButton(1001, this.field_147003_i + 167, this.field_147009_r + 48, this.autoEject);
        this.field_146292_n.add(this.ejb);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 125, this.field_147009_r + 24, this.field_147003_i + 187, this.field_147009_r + 45, "guiText.popup.xpVacuum", guiContainer -> this.xpb.field_146125_m);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 125, this.field_147009_r + 46, this.field_147003_i + 187, this.field_147009_r + 65, "guiText.popup.xpVacuum.eject", guiContainer -> this.xpb.field_146125_m);
    }

    @Override
    protected void setupButtonVisibility() {
        super.setupButtonVisibility();
        this.xpb.field_146125_m = this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.XP_VACUUM) > 0;
        this.ejb.field_146125_m = this.xpb.field_146125_m && !((XPCollection.XPCollectionType)((Object)this.xpb.getState())).isSolid();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.XP_VACUUM) > 0) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.label.xpVacuum", (Object[])new Object[0]), 127, 32, 0xFFFFFF);
            if (!((XPCollection.XPCollectionType)((Object)this.xpb.getState())).isSolid()) {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"guiText.label.xpVacuum.eject", (Object[])new Object[0]), 127, 52, 0xFFFFFF);
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.augmentCounter.getAugmentCount(ItemAugment.AugmentType.XP_VACUUM) > 0) {
            this.func_73729_b(this.field_147003_i + 168, this.field_147009_r + 26, GuiModuleVacuum.BUTTON_XY.x, GuiModuleVacuum.BUTTON_XY.y, 18, 18);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1000: {
                XPTypeButton xpb = (XPTypeButton)button;
                XPCollection.XPCollectionType oldType = (XPCollection.XPCollectionType)((Object)xpb.getState());
                this.xpCollectionType = (XPCollection.XPCollectionType)((Object)xpb.cycle(!GuiScreen.func_146272_n()));
                if (this.xpCollectionType == oldType) break;
                this.sendModuleSettingsToServer();
                break;
            }
            case 1001: {
                EjectButton ejb = (EjectButton)button;
                ejb.toggle();
                this.autoEject = ejb.isToggled();
                this.sendModuleSettingsToServer();
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
    }

    @Override
    protected NBTTagCompound buildMessageData() {
        NBTTagCompound compound = super.buildMessageData();
        compound.func_74768_a("XPFluidType", this.xpCollectionType.ordinal());
        compound.func_74757_a("AutoEject", this.autoEject);
        return compound;
    }

    private class EjectButton
    extends TexturedToggleButton {
        EjectButton(int buttonId, int x, int y, boolean initialVal) {
            super(buttonId, x, y, 16, 16);
            this.setToggled(initialVal);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 192 : 112;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class XPTypeButton
    extends ItemStackCyclerButton<XPCollection.XPCollectionType> {
        private final List<List<String>> tips;

        XPTypeButton(int buttonId, int x, int y, int width, int height, boolean flat, ItemStack[] stacks, XPCollection.XPCollectionType initialVal) {
            super(buttonId, x, y, width, height, flat, stacks, initialVal);
            this.tips = Lists.newArrayList();
            for (XPCollection.XPCollectionType type : XPCollection.XPCollectionType.values()) {
                String modName = ModNameCache.getModName(type.getModId());
                String title = type.getIcon().func_77973_b() instanceof UniversalBucket ? MiscUtil.getFluidName(type.getIcon()) : type.getIcon().func_82833_r();
                this.tips.add((List<String>)ImmutableList.of((Object)title, (Object)(TextFormatting.BLUE + "" + TextFormatting.ITALIC + modName)));
            }
        }

        @Override
        public void setState(XPCollection.XPCollectionType newState) {
            super.setState(newState);
            ((GuiModuleVacuum)GuiModuleVacuum.this).ejb.field_146125_m = ((GuiModuleVacuum)GuiModuleVacuum.this).xpb.field_146125_m && !((XPCollection.XPCollectionType)((Object)GuiModuleVacuum.this.xpb.getState())).isSolid();
        }

        @Override
        public List<String> getTooltip() {
            return this.tips.get(((XPCollection.XPCollectionType)((Object)this.getState())).ordinal());
        }

        @Override
        public boolean isApplicable(XPCollection.XPCollectionType state) {
            return state.isAvailable();
        }
    }
}

