/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.AreaShowHandler;
import me.desht.modularrouters.client.IPositionProvider;
import me.desht.modularrouters.item.module.ItemModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public enum AreaShowManager {
    INSTANCE;

    private final Map<BlockPos, AreaShowHandler> showHandlers = new HashMap<BlockPos, AreaShowHandler>();
    private World world;

    public static AreaShowManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        List<BlockPos> posList;
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (AreaShowHandler handler : this.showHandlers.values()) {
            handler.render();
        }
        ItemStack curItem = player.func_184614_ca();
        IPositionProvider positionProvider = this.getPositionProvider(curItem);
        if (positionProvider != null && (posList = positionProvider.getStoredPositions(curItem)) != null) {
            for (int i = 0; i < posList.size(); ++i) {
                if (posList.get(i) == null || positionProvider.getRenderColor(i) == 0) continue;
                GlStateManager.func_179097_i();
                new AreaShowHandler((Set<BlockPos>)ImmutableSet.of((Object)posList.get(i)), positionProvider.getRenderColor(i)).render();
                GlStateManager.func_179126_j();
            }
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private IPositionProvider getPositionProvider(ItemStack stack) {
        if (stack.func_77973_b() instanceof IPositionProvider) {
            return (IPositionProvider)stack.func_77973_b();
        }
        if (ItemModule.getModule(stack) instanceof IPositionProvider) {
            return (IPositionProvider)((Object)ItemModule.getModule(stack));
        }
        return null;
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        EntityPlayer player = ModularRouters.proxy.getPlayer();
        if (player != null) {
            if (player.field_70170_p != this.world) {
                this.world = player.field_70170_p;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                this.showHandlers.keySet().removeIf(pos -> AreaShowManager.distBetweenSq(pos, player.field_70165_t, player.field_70163_u, player.field_70161_v) < 1024.0 && this.world.func_175623_d(pos));
            }
        }
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetweenSq(BlockPos pos1, double x1, double y1, double z1) {
        return AreaShowManager.distBetweenSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), x1, y1, z1);
    }
}

